"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severityAggregations = exports.alertsGroupingAggregations = exports.alertTypeAggregations = exports.alertRuleAggregations = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY_SIZE = 1000;
const severityAggregations = exports.severityAggregations = {
  statusBySeverity: {
    terms: {
      field: _ruleDataUtils.ALERT_SEVERITY
    }
  }
};
const alertTypeAggregations = exports.alertTypeAggregations = {
  alertsByType: {
    terms: {
      field: _ruleDataUtils.ALERT_RULE_NAME,
      size: DEFAULT_QUERY_SIZE
    },
    aggs: {
      ruleByEventType: {
        terms: {
          field: 'event.type',
          size: DEFAULT_QUERY_SIZE
        }
      }
    }
  }
};
const alertRuleAggregations = exports.alertRuleAggregations = {
  alertsByRule: {
    terms: {
      field: _ruleDataUtils.ALERT_RULE_NAME,
      size: DEFAULT_QUERY_SIZE
    }
  }
};
const alertsGroupingAggregations = stackByField => {
  return {
    alertsByGrouping: {
      terms: {
        field: stackByField,
        size: 10
      }
    },
    missingFields: {
      missing: {
        field: stackByField
      }
    }
  };
};
exports.alertsGroupingAggregations = alertsGroupingAggregations;