"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsByTypePanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _alerts_by_type = require("./alerts_by_type");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var _use_summary_chart_data = require("../alerts_summary_charts_panel/use_summary_chart_data");
var _aggregations = require("../alerts_summary_charts_panel/aggregations");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_BY_TYPE_CHART_ID = 'alerts-summary-alert_by_type';
const AlertsByTypePanel = ({
  filters,
  query,
  signalIndexName,
  runtimeMappings,
  skip
}) => {
  const isAlertTypeEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertTypeEnabled');
  const uniqueQueryId = (0, _react.useMemo)(() => `${ALERTS_BY_TYPE_CHART_ID}-${(0, _uuid.v4)()}`, []);
  const {
    items,
    isLoading
  } = (0, _use_summary_chart_data.useSummaryChartData)({
    aggregations: isAlertTypeEnabled ? _aggregations.alertTypeAggregations : _aggregations.alertRuleAggregations,
    filters,
    query,
    signalIndexName,
    runtimeMappings,
    skip,
    uniqueQueryId
  });
  const data = (0, _react.useMemo)(() => (0, _helpers.getIsAlertsTypeData)(items) ? items : [], [items]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "alerts-by-type-panel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: uniqueQueryId,
    inspectTitle: isAlertTypeEnabled ? i18n.ALERTS_TYPE_TITLE : i18n.ALERTS_RULE_TITLE,
    outerDirection: "row",
    title: isAlertTypeEnabled ? i18n.ALERTS_TYPE_TITLE : i18n.ALERTS_RULE_TITLE,
    titleSize: "xs",
    hideSubtitle: true
  }), /*#__PURE__*/_react.default.createElement(_alerts_by_type.AlertsByType, {
    data: data,
    isLoading: isLoading
  })));
};
exports.AlertsByTypePanel = AlertsByTypePanel;
AlertsByTypePanel.displayName = 'AlertsByTypePanel';