"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTypeTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _cell_actions = require("../../../../common/components/cell_actions");
var _draggables = require("../../../../common/components/draggables");
var _formatted_number = require("../../../../common/components/formatted_number");
var _translations = require("../../alerts_table/translations");
var _helpers = require("./helpers");
var _translations2 = require("../alerts_count_panel/translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../../../common/store/sourcerer/model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsTypeTableColumns = isAlertTypeEnabled => [{
  field: 'rule',
  name: _translations.ALERTS_HEADERS_RULE_NAME,
  'data-test-subj': 'detectionsTable-rule',
  truncateText: true,
  render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    isDraggable: false,
    field: _ruleDataUtils.ALERT_RULE_NAME,
    hideTopN: true,
    id: `alert-detection-draggable-${rule}`,
    value: rule,
    queryValue: rule,
    tooltipContent: null,
    truncate: true
  }))
}, ...(isAlertTypeEnabled ? [{
  field: 'type',
  name: i18n.ALERTS_TYPE_COLUMN_TITLE,
  'data-test-subj': 'detectionsTable-type',
  truncateText: true,
  render: type => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: _helpers.ALERT_TYPE_COLOR[type]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      mode: _cell_actions.CellActionsMode.HOVER_DOWN,
      visibleCellActions: 4,
      showActionTooltips: true,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      data: {
        value: 'denied',
        field: 'event.type'
      },
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        negateFilters: type === 'Detection'
      } // Detection: event.type != denied
    }, _helpers.ALERT_TYPE_LABEL[type])));
  },
  width: '30%'
}] : []), {
  field: 'value',
  name: _translations2.COUNT_TABLE_TITLE,
  dataType: 'number',
  sortable: true,
  'data-test-subj': 'detectionsTable-count',
  render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  })),
  width: '22%'
}];
exports.getAlertsTypeTableColumns = getAlertsTypeTableColumns;