"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsByType = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _formatted_number = require("../../../../common/components/formatted_number");
var _columns = require("./columns");
var _helpers = require("./helpers");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  margin-top: -${({
  theme
}) => theme.eui.euiSizeM};
`;
const TableWrapper = _styledComponents.default.div`
  height: 178px;
`;
const StyledEuiColorPaletteDisplay = (0, _styledComponents.default)(_eui.EuiColorPaletteDisplay)`
  border: none;
  border-radius: 0;
`;
const AlertsByType = ({
  data,
  isLoading
}) => {
  const isAlertTypeEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertTypeEnabled');
  const columns = (0, _react.useMemo)(() => (0, _columns.getAlertsTypeTableColumns)(isAlertTypeEnabled), [isAlertTypeEnabled]);
  const subtotals = (0, _react.useMemo)(() => data.reduce((acc, item) => {
    if (item.type === 'Detection') {
      acc.Detection += item.value;
    }
    if (item.type === 'Prevention') {
      acc.Prevention += item.value;
    }
    return acc;
  }, {
    Detection: 0,
    Prevention: 0
  }), [data]);
  const palette = (0, _react.useMemo)(() => Object.keys(subtotals).reduce((acc, type) => {
    const previousStop = acc.length > 0 ? acc[acc.length - 1].stop : 0;
    if (subtotals[type]) {
      const newEntry = {
        stop: previousStop + (subtotals[type] || 0),
        color: _helpers.ALERT_TYPE_COLOR[type]
      };
      acc.push(newEntry);
    }
    return acc;
  }, []), [subtotals]);
  const sorting = {
    sort: {
      field: 'value',
      direction: 'desc'
    }
  };
  const pagination = {
    pageSize: 25,
    showPerPageOptions: false
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": "alerts-by-type"
  }, isAlertTypeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": "alerts-by-type-palette-display"
  }, Object.keys(subtotals).map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: type,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    className: "eui-alignMiddle",
    color: _helpers.ALERT_TYPE_COLOR[type]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, `${type}:`)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: subtotals[type] || 0
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiColorPaletteDisplay, {
    size: "xs",
    palette: palette
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(TableWrapper, {
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "alerts-by-type-table",
    columns: columns,
    items: data,
    loading: isLoading,
    sorting: sorting,
    pagination: pagination
  })));
};
exports.AlertsByType = AlertsByType;
AlertsByType.displayName = 'AlertsByType';