"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableUrlSavedPagination = exports.RulesTableStorageSavedPagination = exports.RulesTableSavedSorting = exports.RulesTableSavedFilter = exports.RuleSource = void 0;
var z = _interopRequireWildcard(require("zod"));
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _logic = require("../../../../rule_management/logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleSource = exports.RuleSource = /*#__PURE__*/function (RuleSource) {
  RuleSource["Prebuilt"] = "prebuilt";
  RuleSource["Custom"] = "custom";
  return RuleSource;
}({});
const RulesTableSavedFilter = exports.RulesTableSavedFilter = z.object({
  searchTerm: z.string(),
  source: z.nativeEnum(RuleSource),
  tags: z.array(z.string()),
  enabled: z.boolean(),
  ruleExecutionStatus: _detection_engine.RuleExecutionStatus
}).partial();
const RulesTableSavedSorting = exports.RulesTableSavedSorting = _logic.SortingOptions.pick({
  field: true,
  order: true
}).partial();
const RulesTableStorageSavedPagination = exports.RulesTableStorageSavedPagination = _logic.PaginationOptions.pick({
  perPage: true
}).partial();
const RulesTableUrlSavedPagination = exports.RulesTableUrlSavedPagination = _logic.PaginationOptions.pick({
  page: true,
  perPage: true
}).partial();