"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllRules = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _rules_management_tour = require("./rules_table/guided_onboarding/rules_management_tour");
var _use_sync_rules_table_saved_state = require("./rules_table/use_sync_rules_table_saved_state");
var _rules_tables = require("./rules_tables");
var _rules_table_toolbar = require("./rules_table_toolbar");
var _upgrade_prebuilt_rules_table = require("./upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table Component for displaying all Rules for a given cluster. Provides the ability to filter
 * by name, sort by enabled, and perform the following actions:
 *   * Enable/Disable
 *   * Duplicate
 *   * Delete
 *   * Import/Export
 */
const AllRules = exports.AllRules = /*#__PURE__*/_react.default.memo(() => {
  (0, _use_sync_rules_table_saved_state.useSyncRulesTableSavedState)();
  const [{
    tabName
  }] = (0, _use_route_spy.useRouteSpy)();
  if (tabName !== _rules_table_toolbar.AllRulesTabs.updates) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rules_management_tour.RulesManagementTour, null), /*#__PURE__*/_react.default.createElement(_rules_table_toolbar.RulesTableToolbar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rules_tables.RulesTables, {
      selectedTab: tabName
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_context.UpgradePrebuiltRulesTableContextProvider, null, /*#__PURE__*/_react.default.createElement(_rules_table_toolbar.RulesTableToolbar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table.UpgradePrebuiltRulesTable, null)));
  }
});
AllRules.displayName = 'AllRules';