"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkEditFormFlyout = void 0;
var _react = require("react");
var _use_async_confirmation = require("../rules_table/use_async_confirmation");
var _use_bool_state = require("../../../../../common/hooks/use_bool_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkEditFormFlyout = () => {
  const dataFormRef = (0, _react.useRef)(null);
  const [actionType, setActionType] = (0, _react.useState)();
  const [isBulkEditFlyoutVisible, showBulkEditFlyout, hideBulkEditFlyout] = (0, _use_bool_state.useBoolState)();
  const [confirmForm, onConfirm, onCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showBulkEditFlyout,
    onFinish: hideBulkEditFlyout
  });
  const completeBulkEditForm = (0, _react.useCallback)(async editActionType => {
    setActionType(editActionType);
    if ((await confirmForm()) === true) {
      return dataFormRef.current;
    } else {
      return null;
    }
  }, [confirmForm]);
  const handleBulkEditFormConfirm = (0, _react.useCallback)(data => {
    dataFormRef.current = data;
    onConfirm();
  }, [onConfirm]);
  return {
    bulkEditActionType: actionType,
    isBulkEditFlyoutVisible,
    handleBulkEditFormConfirm,
    handleBulkEditFormCancel: onCancel,
    completeBulkEditForm
  };
};
exports.useBulkEditFormFlyout = useBulkEditFormFlyout;