"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditFormWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var i18n = _interopRequireWildcard(require("../../../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditFormWrapperComponent = ({
  form,
  title,
  banner,
  children,
  onClose,
  onSubmit,
  flyoutSize = 's'
}) => {
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'RulesBulkEditForm'
  });
  const {
    isValid
  } = form;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": simpleFlyoutTitleId,
    size: flyoutSize
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "rulesBulkEditFormTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: banner
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "rulesBulkEditFormCancelBtn"
  }, i18n.BULK_EDIT_FLYOUT_FORM_CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSubmit,
    fill: true,
    disabled: isValid === false,
    "data-test-subj": "rulesBulkEditFormSaveBtn"
  }, i18n.BULK_EDIT_FLYOUT_FORM_SAVE)))));
};
const BulkEditFormWrapper = exports.BulkEditFormWrapper = /*#__PURE__*/_react.default.memo(BulkEditFormWrapperComponent);
BulkEditFormWrapper.displayName = 'BulkEditFormWrapper';