"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionRuleErrorsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditRuleErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  switch (errorCode) {
    case _constants.BulkActionsDryRunErrCode.IMMUTABLE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.elasticRulesEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# prebuilt Elastic rule} other {# prebuilt Elastic rules}} (editing prebuilt rules is not supported)",
        values: {
          rulesCount
        }
      }));
    case _constants.BulkActionsDryRunErrCode.MACHINE_LEARNING_INDEX_PATTERN:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.machineLearningRulesIndexEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# custom machine learning rule} other {# custom machine learning rules}} (these rules don't have index patterns)",
        values: {
          rulesCount
        }
      }));
    case _constants.BulkActionsDryRunErrCode.MACHINE_LEARNING_AUTH:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.machineLearningRulesAuthDescription",
        defaultMessage: "{rulesCount, plural, =1 {# machine learning rule} other {# machine learning rules}} can't be edited ({message})",
        values: {
          rulesCount,
          message
        }
      }));
    case _constants.BulkActionsDryRunErrCode.ESQL_INDEX_PATTERN:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.esqlRulesIndexEditDescription",
        defaultMessage: "{rulesCount, plural, =1 {# custom ES|QL rule} other {# custom ES|QL rules}} (these rules don't have index patterns)",
        values: {
          rulesCount
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultRulesEditFailureDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be edited ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkExportRuleErrorItem = ({
  errorCode,
  message,
  rulesCount
}) => {
  switch (errorCode) {
    case _constants.BulkActionsDryRunErrCode.IMMUTABLE:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.elasticRulesExportDescription",
        defaultMessage: "{rulesCount, plural, =1 {# prebuilt Elastic rule} other {# prebuilt Elastic rules}} (exporting prebuilt rules is not supported)",
        values: {
          rulesCount
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement("li", {
        key: message
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.defaultRulesExportFailureDescription",
        defaultMessage: "{rulesCount, plural, =1 {# rule} other {# rules}} can't be exported ({message})",
        values: {
          rulesCount,
          message
        }
      }));
  }
};
const BulkActionRuleErrorsListComponent = ({
  ruleErrors = [],
  bulkAction
}) => {
  if (ruleErrors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.actionRejectionDescription",
    defaultMessage: "This action can't be applied to the following rules in your selection:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("ul", null, ruleErrors.map(({
    message,
    errorCode,
    ruleIds
  }) => {
    const rulesCount = ruleIds.length;
    switch (bulkAction) {
      case _rule_management.BulkActionTypeEnum.edit:
        return /*#__PURE__*/_react.default.createElement(BulkEditRuleErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      case _rule_management.BulkActionTypeEnum.export:
        return /*#__PURE__*/_react.default.createElement(BulkExportRuleErrorItem, {
          message: message,
          errorCode: errorCode,
          rulesCount: rulesCount
        });
      default:
        return null;
    }
  })));
};
const BulkActionRuleErrorsList = exports.BulkActionRuleErrorsList = /*#__PURE__*/_react.default.memo(BulkActionRuleErrorsListComponent);
BulkActionRuleErrorsList.displayName = 'BulkActionRuleErrorsList';