"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleScheduleSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Interval = ({
  interval
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "intervalPropertyValue"
}, interval);
const From = ({
  from,
  interval
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": `fromPropertyValue-${from}`
}, (0, _helpers.getHumanizedDuration)(from, interval));
const RuleScheduleSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  if (!rule.interval || !rule.from) {
    return null;
  }
  const ruleSectionListItems = [];
  ruleSectionListItems.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle"
    }, i18n.INTERVAL_FIELD_LABEL),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: rule.interval
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromPropertyTitle"
    }, i18n.FROM_FIELD_LABEL),
    description: /*#__PURE__*/_react.default.createElement(From, {
      from: rule.from,
      interval: rule.interval
    })
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: ruleSectionListItems,
    columnWidths: columnWidths
  }, descriptionListProps)));
};
exports.RuleScheduleSection = RuleScheduleSection;