"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedFieldDiffGroups = void 0;
var _get_field_diffs_for_grouped_fields = require("./get_field_diffs_for_grouped_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedFieldDiffGroups = (fieldName, fields) => {
  /**
   * Field types that contain groupings of rule fields must be formatted differently to compare and render
   * each individual nested field and to satisfy types
   *
   * Setting shouldShowSubtitles to `true` displays the grouped field names in the rendered diff component
   */
  switch (fieldName) {
    case 'data_source':
      const dataSourceThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForDataSource)(dataSourceThreeWayDiff)
      };
    case 'kql_query':
      const kqlQueryThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForKqlQuery)(kqlQueryThreeWayDiff)
      };
    case 'eql_query':
      const eqlQueryThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForEqlQuery)(eqlQueryThreeWayDiff)
      };
    case 'esql_query':
      const esqlQueryThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForEsqlQuery)(esqlQueryThreeWayDiff)
      };
    case 'threat_query':
      const threatQueryThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForThreatQuery)(threatQueryThreeWayDiff)
      };
    case 'rule_schedule':
      const ruleScheduleThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForRuleSchedule)(ruleScheduleThreeWayDiff)
      };
    case 'rule_name_override':
      const ruleNameOverrideThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForRuleNameOverride)(ruleNameOverrideThreeWayDiff)
      };
    case 'timestamp_override':
      const timestampOverrideThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForTimestampOverride)(timestampOverrideThreeWayDiff)
      };
    case 'timeline_template':
      const timelineTemplateThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForTimelineTemplate)(timelineTemplateThreeWayDiff)
      };
    case 'building_block':
      const buildingBlockThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForBuildingBlock)(buildingBlockThreeWayDiff)
      };
    case 'threshold':
      const thresholdThreeWayDiff = fields[fieldName];
      return {
        shouldShowSubtitles: true,
        fieldDiffs: (0, _get_field_diffs_for_grouped_fields.getFieldDiffsForThreshold)(thresholdThreeWayDiff)
      };
    default:
      const fieldThreeWayDiff = fields[fieldName];
      const currentVersionField = (0, _get_field_diffs_for_grouped_fields.sortAndStringifyJson)(fieldThreeWayDiff.current_version);
      const targetVersionField = (0, _get_field_diffs_for_grouped_fields.sortAndStringifyJson)(fieldThreeWayDiff.target_version);
      return {
        shouldShowSubtitles: false,
        fieldDiffs: currentVersionField !== targetVersionField ? [{
          fieldName,
          currentVersion: currentVersionField,
          targetVersion: targetVersionField
        }] : []
      };
  }
};
exports.getFormattedFieldDiffGroups = getFormattedFieldDiffGroups;