"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATED_VERSION_DESCRIPTION = exports.EXPAND_UNCHANGED_LINES = exports.ELASTIC_UPDATE_VERSION = exports.CURRENT_VERSION_DESCRIPTION = exports.CURRENT_RULE_VERSION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXPAND_UNCHANGED_LINES = linesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.expandHiddenDiffLinesLabel', {
  values: {
    linesCount
  },
  defaultMessage: 'Expand {linesCount} unchanged {linesCount, plural, one {line} other {lines}}'
});
exports.EXPAND_UNCHANGED_LINES = EXPAND_UNCHANGED_LINES;
const CURRENT_RULE_VERSION = exports.CURRENT_RULE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.currentVersionLabel', {
  defaultMessage: 'Current rule'
});
const CURRENT_VERSION_DESCRIPTION = exports.CURRENT_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.currentVersionDescriptionLabel', {
  defaultMessage: 'Shows currently installed rule'
});
const ELASTIC_UPDATE_VERSION = exports.ELASTIC_UPDATE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.elasticUpdateVersionLabel', {
  defaultMessage: 'Elastic update'
});
const UPDATED_VERSION_DESCRIPTION = exports.UPDATED_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.updatedVersionDescriptionLabel', {
  defaultMessage: 'Shows rule that will be installed'
});