"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hunks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDiffView = require("react-diff-view");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnfoldButton = ({
  start,
  end,
  onExpand,
  ...props
}) => {
  const expand = (0, _react.useCallback)(() => onExpand(start, end), [onExpand, start, end]);
  const linesCount = end - start;
  return /*#__PURE__*/_react.default.createElement(_reactDiffView.Decoration, props, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, start > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: expand
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortable"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18n.EXPAND_UNCHANGED_LINES(linesCount))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
const UnfoldCollapsed = ({
  previousHunk,
  currentHunk,
  linesCount,
  onExpand
}) => {
  if (!currentHunk) {
    const nextStart = previousHunk.oldStart + previousHunk.oldLines;
    const collapsedLines = linesCount - nextStart + 1;
    if (collapsedLines <= 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: nextStart,
      end: linesCount + 1,
      onExpand: onExpand
    });
  }
  const collapsedLines = (0, _reactDiffView.getCollapsedLinesCountBetween)(previousHunk, currentHunk);
  if (!previousHunk) {
    if (!collapsedLines) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
      start: 1,
      end: currentHunk.oldStart,
      onExpand: onExpand
    });
  }
  const collapsedStart = previousHunk.oldStart + previousHunk.oldLines;
  const collapsedEnd = currentHunk.oldStart;
  return /*#__PURE__*/_react.default.createElement(UnfoldButton, {
    start: collapsedStart,
    end: collapsedEnd,
    onExpand: onExpand
  });
};
const Hunks = ({
  hunks,
  oldSource,
  expandRange
}) => {
  const linesCount = oldSource.split('\n').length;
  const hunkElements = hunks.reduce((children, hunk, index) => {
    const previousElement = children[children.length - 1];

    // If old source doesn't exist, we don't render expandable sections
    if (!oldSource) {
      children.push( /*#__PURE__*/_react.default.createElement(_reactDiffView.Hunk, {
        key: `hunk-${hunk.content}`,
        hunk: hunk
      }));
      return children;
    }
    children.push( /*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
      key: `decoration-${hunk.content}`,
      previousHunk: previousElement && previousElement.props.hunk,
      currentHunk: hunk,
      linesCount: linesCount,
      onExpand: expandRange
    }));
    children.push( /*#__PURE__*/_react.default.createElement(_reactDiffView.Hunk, {
      key: `hunk-${hunk.content}`,
      hunk: hunk
    }));
    const isLastHunk = index === hunks.length - 1;
    if (isLastHunk && oldSource) {
      children.push( /*#__PURE__*/_react.default.createElement(UnfoldCollapsed, {
        key: "decoration-tail",
        previousHunk: hunk,
        linesCount: linesCount,
        onExpand: expandRange
      }));
    }
    return children;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hunkElements);
};
exports.Hunks = Hunks;