"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSectionedFieldDiffs = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSectionedFieldDiffs = fields => {
  const aboutFields = [];
  const definitionFields = [];
  const scheduleFields = [];
  const setupFields = [];
  for (const field of fields) {
    if (_constants.ABOUT_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      aboutFields.push(field);
    } else if (_constants.DEFINITION_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      definitionFields.push(field);
    } else if (_constants.SCHEDULE_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      scheduleFields.push(field);
    } else if (_constants.SETUP_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      setupFields.push(field);
    }
  }
  return {
    aboutFields,
    definitionFields,
    scheduleFields,
    setupFields
  };
};
exports.getSectionedFieldDiffs = getSectionedFieldDiffs;