"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDiffSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _field_diff = require("./field_diff");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleDiffSection = ({
  title,
  fieldGroups,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  "data-test-subj": dataTestSubj,
  initialIsOpen: true,
  id: title,
  css: (0, _css.css)`
        padding-top: 1px; // Fixes border disappearing bug
      `,
  buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "ruleUpgradePerFieldDiffSectionHeader",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))
}, fieldGroups.map(({
  fieldsGroupName,
  formattedDiffs
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: fieldsGroupName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_field_diff.FieldGroupDiffComponent, {
    ruleDiffs: formattedDiffs,
    fieldsGroupName: fieldsGroupName
  }));
})));
exports.RuleDiffSection = RuleDiffSection;