"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldGroupDiffComponent = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _diff_view = require("../json_diff/diff_view");
var _panel_wrapper = require("./panel_wrapper");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubFieldComponent = ({
  currentVersion,
  targetVersion,
  fieldName,
  shouldShowSeparator,
  shouldShowSubtitles
}) => {
  var _fieldToDisplayNameMa;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, shouldShowSubtitles ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "ruleUpgradePerFieldDiffSubtitle",
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, (_fieldToDisplayNameMa = _translations.fieldToDisplayNameMap[fieldName]) !== null && _fieldToDisplayNameMa !== void 0 ? _fieldToDisplayNameMa : (0, _lodash.startCase)((0, _lodash.camelCase)(fieldName)))) : null, /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
    oldSource: currentVersion,
    newSource: targetVersion
  }), shouldShowSeparator ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    size: "full"
  }) : null));
};
const FieldGroupDiffComponent = ({
  ruleDiffs,
  fieldsGroupName
}) => {
  const {
    fieldDiffs,
    shouldShowSubtitles
  } = ruleDiffs;
  return /*#__PURE__*/_react.default.createElement(_panel_wrapper.RuleDiffPanelWrapper, {
    fieldName: fieldsGroupName
  }, fieldDiffs.map(({
    currentVersion,
    targetVersion,
    fieldName: specificFieldName
  }, index) => {
    const shouldShowSeparator = index !== fieldDiffs.length - 1;
    return /*#__PURE__*/_react.default.createElement(SubFieldComponent, {
      key: specificFieldName,
      shouldShowSeparator: shouldShowSeparator,
      shouldShowSubtitles: shouldShowSubtitles,
      currentVersion: currentVersion,
      targetVersion: targetVersion,
      fieldName: specificFieldName
    });
  }));
};
exports.FieldGroupDiffComponent = FieldGroupDiffComponent;