"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddExceptionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _item_comments = require("../item_comments");
var _helpers = require("../../utils/helpers");
var _reducer = require("./reducer");
var _item_meta_form = require("../flyout_components/item_meta_form");
var _item_conditions = require("../flyout_components/item_conditions");
var _use_exception_flyout_data = require("../../logic/use_exception_flyout_data");
var _alerts_actions = require("../flyout_components/alerts_actions");
var _add_exception_to_rule_or_list = require("../flyout_components/add_exception_to_rule_or_list");
var _use_add_new_exceptions = require("./use_add_new_exceptions");
var _utils = require("../flyout_components/utils");
var _use_close_alerts = require("../../logic/use_close_alerts");
var _constants = require("../../utils/constants");
var _use_fetch_rule_by_id_query = require("../../../rule_management/api/hooks/use_fetch_rule_by_id_query");
var _expire_time = require("../flyout_components/expire_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const FlyoutBodySection = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  ${() => (0, _styledComponents.css)`
    &.builder-section {
      overflow-y: scroll;
    }
  `}
`;
const FlyoutHeader = (0, _styledComponents.default)(_eui.EuiFlyoutHeader)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    border-bottom: 1px solid ${theme.eui.euiColorLightShade};
  `}
`;
const FlyoutFooterGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    padding: ${theme.eui.euiSizeS};
  `}
`;
const AddExceptionFlyout = exports.AddExceptionFlyout = /*#__PURE__*/(0, _react.memo)(function AddExceptionFlyout({
  rules,
  isBulkAction,
  isEndpointItem,
  alertData,
  showAlertCloseOptions,
  isAlertDataLoading,
  alertStatus,
  sharedListToAddTo,
  onCancel,
  onConfirm
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isLoading,
    indexPatterns,
    getExtendedFields
  } = (0, _use_exception_flyout_data.useFetchIndexPatterns)(rules);
  const [isSubmitting, submitNewExceptionItems] = (0, _use_add_new_exceptions.useAddNewExceptionItems)();
  const [isClosingAlerts, closeAlerts] = (0, _use_close_alerts.useCloseAlertsFromExceptions)();
  const invalidateFetchRuleByIdQuery = (0, _use_fetch_rule_by_id_query.useInvalidateFetchRuleByIdQuery)();
  const allowLargeValueLists = (0, _react.useMemo)(() => {
    if (rules != null && rules.length === 1) {
      // We'll only block this when we know what rule we're dealing with.
      // When dealing with numerous rules that can be a mix of those that do and
      // don't work with large value lists we'll need to communicate that to the
      // user but not block.
      return _constants.ruleTypesThatAllowLargeValueLists.includes(rules[0].type);
    } else {
      return true;
    }
  }, [rules]);
  const addExceptionToRuleOrListSelection = (0, _react.useMemo)(() => {
    if (isBulkAction) return 'add_to_rules';
    if ((rules === null || rules === void 0 ? void 0 : rules.length) === 1 || isAlertDataLoading !== undefined) return 'add_to_rule';
    return 'select_rules_to_add_to';
  }, [isAlertDataLoading, isBulkAction, rules]);
  const getListType = (0, _react.useMemo)(() => {
    if (isEndpointItem) return _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT;
    if (sharedListToAddTo) return _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION;
    return _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT;
  }, [isEndpointItem, sharedListToAddTo]);
  const [{
    exceptionItemMeta: {
      name: exceptionItemName
    },
    listType,
    selectedOs,
    initialItems,
    exceptionItems,
    disableBulkClose,
    bulkCloseAlerts,
    closeSingleAlert,
    bulkCloseIndex,
    addExceptionToRadioSelection,
    selectedRulesToAddTo,
    exceptionListsToAddTo,
    newComment,
    commentErrorExists,
    itemConditionValidationErrorExists,
    errorSubmitting,
    expireTime,
    expireErrorExists
  }, dispatch] = (0, _react.useReducer)((0, _reducer.createExceptionItemsReducer)(), {
    ..._reducer.initialState,
    addExceptionToRadioSelection: addExceptionToRuleOrListSelection,
    listType: getListType,
    selectedRulesToAddTo: rules != null ? rules : []
  });
  const hasAlertData = (0, _react.useMemo)(() => {
    return alertData != null;
  }, [alertData]);

  /**
   * Reducer action dispatchers
   * */
  const setInitialExceptionItems = (0, _react.useCallback)(items => {
    dispatch({
      type: 'setInitialExceptionItems',
      items
    });
  }, [dispatch]);
  const setExceptionItemsToAdd = (0, _react.useCallback)(items => {
    dispatch({
      type: 'setExceptionItems',
      items
    });
  }, [dispatch]);
  const setRadioOption = (0, _react.useCallback)(option => {
    dispatch({
      type: 'setListOrRuleRadioOption',
      option
    });
  }, [dispatch]);
  const setSelectedRules = (0, _react.useCallback)(rulesSelectedToAdd => {
    dispatch({
      type: 'setSelectedRulesToAddTo',
      rules: rulesSelectedToAdd
    });
  }, [dispatch]);
  const setListsToAddExceptionTo = (0, _react.useCallback)(lists => {
    dispatch({
      type: 'setAddExceptionToLists',
      listsToAddTo: lists
    });
  }, [dispatch]);
  const setExceptionItemMeta = (0, _react.useCallback)(value => {
    dispatch({
      type: 'setExceptionItemMeta',
      value
    });
  }, [dispatch]);
  const setConditionsValidationError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setConditionValidationErrorExists',
      errorExists
    });
  }, [dispatch]);
  const setSelectedOs = (0, _react.useCallback)(os => {
    dispatch({
      type: 'setSelectedOsOptions',
      selectedOs: os
    });
  }, [dispatch]);
  const setComment = (0, _react.useCallback)(comment => {
    dispatch({
      type: 'setComment',
      comment
    });
  }, [dispatch]);
  const setCommentError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setCommentError',
      errorExists
    });
  }, [dispatch]);
  const setBulkCloseIndex = (0, _react.useCallback)(index => {
    dispatch({
      type: 'setBulkCloseIndex',
      bulkCloseIndex: index
    });
  }, [dispatch]);
  const setCloseSingleAlert = (0, _react.useCallback)(close => {
    dispatch({
      type: 'setCloseSingleAlert',
      close
    });
  }, [dispatch]);
  const setBulkCloseAlerts = (0, _react.useCallback)(bulkClose => {
    dispatch({
      type: 'setBulkCloseAlerts',
      bulkClose
    });
  }, [dispatch]);
  const setDisableBulkCloseAlerts = (0, _react.useCallback)(disableBulkCloseAlerts => {
    dispatch({
      type: 'setDisableBulkCloseAlerts',
      disableBulkCloseAlerts
    });
  }, [dispatch]);
  const setErrorSubmitting = (0, _react.useCallback)(err => {
    dispatch({
      type: 'setErrorSubmitting',
      err
    });
  }, [dispatch]);
  const setExpireTime = (0, _react.useCallback)(exceptionExpireTime => {
    dispatch({
      type: 'setExpireTime',
      expireTime: exceptionExpireTime
    });
  }, [dispatch]);
  const setExpireError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setExpireError',
      errorExists
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (alertData) {
      switch (listType) {
        case _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT:
          {
            return setInitialExceptionItems((0, _helpers.defaultEndpointExceptionItems)(_securitysolutionListConstants.ENDPOINT_LIST_ID, exceptionItemName, alertData));
          }
        case _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT:
          {
            var _rules$0$investigatio, _rules$, _rules$$investigation;
            const populatedException = (0, _helpers.getPrepopulatedRuleExceptionWithHighlightFields)({
              alertData,
              exceptionItemName,
              // With "rule_default" type, there is only ever one rule associated.
              // That is why it's ok to pull just the first item from rules array here.
              ruleCustomHighlightedFields: (_rules$0$investigatio = rules === null || rules === void 0 ? void 0 : (_rules$ = rules[0]) === null || _rules$ === void 0 ? void 0 : (_rules$$investigation = _rules$.investigation_fields) === null || _rules$$investigation === void 0 ? void 0 : _rules$$investigation.field_names) !== null && _rules$0$investigatio !== void 0 ? _rules$0$investigatio : []
            });
            if (populatedException) {
              setComment(i18n.ADD_RULE_EXCEPTION_FROM_ALERT_COMMENT(alertData._id));
              return setInitialExceptionItems([populatedException]);
            }
          }
      }
    }
  }, [listType, exceptionItemName, alertData, rules, setInitialExceptionItems, setComment]);
  const osTypesSelection = (0, _react.useMemo)(() => {
    return hasAlertData ? (0, _helpers.retrieveAlertOsTypes)(alertData) : selectedOs ? [...selectedOs] : [];
  }, [hasAlertData, alertData, selectedOs]);
  const handleOnSubmit = (0, _react.useCallback)(async () => {
    if (submitNewExceptionItems == null) return;
    try {
      const ruleDefaultOptions = ['add_to_rule', 'add_to_rules', 'select_rules_to_add_to'];
      const addToRules = ruleDefaultOptions.includes(addExceptionToRadioSelection);
      const addToSharedLists = !!(sharedListToAddTo !== null && sharedListToAddTo !== void 0 && sharedListToAddTo.length) || addExceptionToRadioSelection === 'add_to_lists' && !(0, _fp.isEmpty)(exceptionListsToAddTo);
      const sharedLists = sharedListToAddTo !== null && sharedListToAddTo !== void 0 && sharedListToAddTo.length ? sharedListToAddTo : exceptionListsToAddTo;
      const items = (0, _utils.enrichNewExceptionItems)({
        itemName: exceptionItemName,
        commentToAdd: newComment,
        addToRules,
        addToSharedLists,
        sharedLists,
        listType,
        selectedOs: osTypesSelection,
        expireTime,
        items: exceptionItems
      });
      const addedItems = await submitNewExceptionItems({
        itemsToAdd: items,
        selectedRulesToAddTo,
        listType,
        addToRules: addToRules && !(0, _fp.isEmpty)(selectedRulesToAddTo),
        addToSharedLists,
        sharedLists
      });
      const alertIdToClose = closeSingleAlert && alertData ? alertData._id : undefined;
      const ruleStaticIds = addToRules ? selectedRulesToAddTo.map(({
        rule_id: ruleId
      }) => ruleId) : (rules !== null && rules !== void 0 ? rules : []).map(({
        rule_id: ruleId
      }) => ruleId);
      if (closeAlerts != null && !(0, _fp.isEmpty)(ruleStaticIds) && (bulkCloseAlerts || closeSingleAlert)) {
        await closeAlerts(ruleStaticIds, addedItems, alertIdToClose, bulkCloseIndex);
      }
      invalidateFetchRuleByIdQuery();
      // Rule only would have been updated if we had to create a rule default list
      // to attach to it, all shared lists would already be referenced on the rule
      onConfirm(true, closeSingleAlert, bulkCloseAlerts);
    } catch (e) {
      setErrorSubmitting(e);
    }
  }, [sharedListToAddTo, submitNewExceptionItems, addExceptionToRadioSelection, exceptionItemName, newComment, exceptionListsToAddTo, listType, osTypesSelection, exceptionItems, selectedRulesToAddTo, closeSingleAlert, alertData, rules, closeAlerts, bulkCloseAlerts, onConfirm, bulkCloseIndex, setErrorSubmitting, invalidateFetchRuleByIdQuery, expireTime]);
  const isSubmitButtonDisabled = (0, _react.useMemo)(() => isSubmitting || isClosingAlerts || errorSubmitting != null || exceptionItemName.trim() === '' || exceptionItems.every(item => item.entries.length === 0) || itemConditionValidationErrorExists || commentErrorExists || expireErrorExists || addExceptionToRadioSelection === 'add_to_lists' && (0, _fp.isEmpty)(exceptionListsToAddTo) || addExceptionToRadioSelection === 'select_rules_to_add_to' && (0, _fp.isEmpty)(selectedRulesToAddTo) && listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT, [isSubmitting, isClosingAlerts, errorSubmitting, exceptionItemName, exceptionItems, itemConditionValidationErrorExists, addExceptionToRadioSelection, exceptionListsToAddTo, expireErrorExists, selectedRulesToAddTo, listType, commentErrorExists]);
  const handleDismissError = (0, _react.useCallback)(() => {
    setErrorSubmitting(null);
  }, [setErrorSubmitting]);
  const handleCloseFlyout = (0, _react.useCallback)(() => {
    onCancel(false);
  }, [onCancel]);
  const addExceptionMessage = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.ADD_ENDPOINT_EXCEPTION : i18n.CREATE_RULE_EXCEPTION;
  }, [listType]);
  const exceptionFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'exceptionFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    onClose: handleCloseFlyout,
    "data-test-subj": "addExceptionFlyout",
    "aria-labelledby": exceptionFlyoutTitleId
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: {
      style: `z-index: ${euiTheme.levels.flyout + 3}`
    } // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
  }, /*#__PURE__*/_react.default.createElement(FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: exceptionFlyoutTitleId,
    "data-test-subj": "exceptionFlyoutTitle"
  }, addExceptionMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(FlyoutBodySection, {
    className: "builder-section"
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "loadingAddExceptionFlyout",
    lines: 4
  }), errorSubmitting != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "addExceptionErrorCallOut",
    title: i18n.SUBMIT_ERROR_TITLE,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.SUBMIT_ERROR_DISMISS_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addExceptionErrorDismissButton",
    color: "danger",
    onClick: handleDismissError
  }, i18n.SUBMIT_ERROR_DISMISS_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_item_meta_form.ExceptionsFlyoutMeta, {
    exceptionItemName: exceptionItemName,
    onChange: setExceptionItemMeta
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_item_conditions.ExceptionsConditions, {
    exceptionItemName: exceptionItemName,
    allowLargeValueLists: allowLargeValueLists,
    exceptionListItems: initialItems,
    exceptionListType: listType,
    indexPatterns: indexPatterns,
    rules: rules,
    selectedOs: selectedOs,
    showOsTypeOptions: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && !hasAlertData,
    isEdit: false,
    onOsChange: setSelectedOs,
    onExceptionItemAdd: setExceptionItemsToAdd,
    onSetErrorExists: setConditionsValidationError,
    getExtendedFields: getExtendedFields
  }), listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && !(sharedListToAddTo !== null && sharedListToAddTo !== void 0 && sharedListToAddTo.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_add_exception_to_rule_or_list.ExceptionsAddToRulesOrLists, {
    rules: rules,
    isBulkAction: isBulkAction,
    selectedRadioOption: addExceptionToRadioSelection,
    onListSelectionChange: setListsToAddExceptionTo,
    onRuleSelectionChange: setSelectedRules,
    onRadioChange: setRadioOption
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_item_comments.ExceptionItemComments, {
    accordionTitle: /*#__PURE__*/_react.default.createElement(SectionHeader, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.COMMENTS_SECTION_TITLE(newComment ? 1 : 0))),
    initialIsOpen: !!newComment,
    newCommentValue: newComment,
    newCommentOnChange: setComment,
    setCommentError: setCommentError
  }), listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_expire_time.ExceptionsExpireTime, {
    expireTime: expireTime,
    setExpireTime: setExpireTime,
    setExpireError: setExpireError
  })), showAlertCloseOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_alerts_actions.ExceptionItemsFlyoutAlertsActions, {
    exceptionListType: listType,
    shouldCloseSingleAlert: closeSingleAlert,
    shouldBulkCloseAlert: bulkCloseAlerts,
    disableBulkClose: disableBulkClose,
    exceptionListItems: exceptionItems,
    alertData: alertData,
    alertStatus: alertStatus,
    isAlertDataLoading: isAlertDataLoading !== null && isAlertDataLoading !== void 0 ? isAlertDataLoading : false,
    onDisableBulkClose: setDisableBulkCloseAlerts,
    onUpdateBulkCloseIndex: setBulkCloseIndex,
    onBulkCloseCheckboxChange: setBulkCloseAlerts,
    onSingleAlertCloseCheckboxChange: setCloseSingleAlert
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(FlyoutFooterGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelExceptionAddButton",
    onClick: handleCloseFlyout
  }, i18n.CANCEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "addExceptionConfirmButton",
    onClick: handleOnSubmit,
    isDisabled: isSubmitButtonDisabled,
    fill: true
  }, addExceptionMessage))));
});