"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateRulePage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _utils = require("../../../../../common/detection_engine/utils");
var _logic = require("../../../rule_management/logic");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _privileges = require("../../../../common/utils/privileges");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _accordion_title = require("../../components/accordion_title");
var _step_define_rule = require("../../components/step_define_rule");
var _use_experimental_feature_fields_transform = require("../../components/step_define_rule/use_experimental_feature_fields_transform");
var _step_about_rule = require("../../components/step_about_rule");
var _step_schedule_rule = require("../../components/step_schedule_rule");
var _step_rule_actions = require("../../../rule_creation/components/step_rule_actions");
var RuleI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var _types = require("../../../../detections/pages/detection_engine/rules/types");
var _helpers2 = require("./helpers");
var _hooks = require("../../hooks");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../../app/types");
var _utils2 = require("../../../../detections/pages/detection_engine/rules/utils");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _rule_preview = require("../../components/rule_preview");
var _helpers3 = require("../../components/rule_preview/helpers");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
var _next_step = require("../../components/next_step");
var _form = require("../form");
var _ = require("..");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  position: relative;
  z-index: ${props => props.zindex}; /* ugly fix to allow searchBar to overflow the EuiPanel */

  > .euiAccordion > .euiAccordion__triggerWrapper {
    .euiAccordion__button {
      cursor: default !important;
      &:hover {
        text-decoration: none !important;
      }
    }

    .euiAccordion__iconWrapper {
      display: none;
    }
  }
  .euiAccordion__childWrapper {
    transform: none; /* To circumvent an issue in Eui causing the fullscreen datagrid to break */
  }
`;
MyEuiPanel.displayName = 'MyEuiPanel';
const CreateRulePageComponent = () => {
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const {
    application,
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const loading = userInfoLoading || listsConfigLoading;
  const [activeStep, setActiveStep] = (0, _react.useState)(_types.RuleStep.defineRule);
  const getNextStep = step => _utils2.ruleStepsOrder[_utils2.ruleStepsOrder.indexOf(step) + 1];
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const defineRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const aboutRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const scheduleRuleRef = (0, _react.useRef)(null);
  // @ts-expect-error EUI team to resolve: https://github.com/elastic/eui/issues/5985
  const ruleActionsRef = (0, _react.useRef)(null);
  const [indicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_INDEX_KEY);
  const [threatIndicesConfig] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_THREAT_INDEX_KEY);
  const defineStepDefault = (0, _react.useMemo)(() => ({
    ..._utils2.stepDefineDefaultValue,
    index: indicesConfig,
    threatIndex: threatIndicesConfig
  }), [indicesConfig, threatIndicesConfig]);
  const kibanaAbsoluteUrl = (0, _react.useMemo)(() => application.getUrlForApp(`${_constants.APP_UI_ID}`, {
    absolute: true
  }), [application]);
  const actionsStepDefault = (0, _react.useMemo)(() => ({
    ..._step_rule_actions.stepActionsDefaultValue,
    kibanaSiemAppUrl: kibanaAbsoluteUrl
  }), [kibanaAbsoluteUrl]);
  const {
    defineStepForm,
    defineStepData,
    aboutStepForm,
    aboutStepData,
    scheduleStepForm,
    scheduleStepData,
    actionsStepForm,
    actionsStepData,
    eqlOptionsSelected,
    setEqlOptionsSelected
  } = (0, _form.useRuleForms)({
    defineStepDefault,
    aboutStepDefault: _utils2.stepAboutDefaultValue,
    scheduleStepDefault: _utils2.defaultSchedule,
    actionsStepDefault
  });
  const isThreatMatchRuleValue = (0, _react.useMemo)(() => (0, _utils.isThreatMatchRule)(defineStepData.ruleType), [defineStepData.ruleType]);
  const isEsqlRuleValue = (0, _react.useMemo)(() => (0, _utils.isEsqlRule)(defineStepData.ruleType), [defineStepData.ruleType]);
  const [openSteps, setOpenSteps] = (0, _react.useState)({
    [_types.RuleStep.defineRule]: false,
    [_types.RuleStep.aboutRule]: false,
    [_types.RuleStep.scheduleRule]: false,
    [_types.RuleStep.ruleActions]: false
  });
  const {
    mutateAsync: createRule,
    isLoading: isCreateRuleLoading
  } = (0, _logic.useCreateRule)();
  const ruleType = defineStepData.ruleType;
  const actionMessageParams = (0, _react.useMemo)(() => (0, _helpers.getActionMessageParams)(ruleType), [ruleType]);
  const [dataViewOptions, setDataViewOptions] = (0, _react.useState)({});
  const [isRulePreviewVisible, setIsRulePreviewVisible] = (0, _react.useState)(true);
  const collapseFn = (0, _react.useRef)();
  const [prevRuleType, setPrevRuleType] = (0, _react.useState)();
  const [isQueryBarValid, setIsQueryBarValid] = (0, _react.useState)(false);
  const [isThreatQueryBarValid, setIsThreatQueryBarValid] = (0, _react.useState)(false);
  const esqlQueryForAboutStep = (0, _hooks.useEsqlQueryForAboutStep)({
    defineStepData,
    activeStep
  });
  const esqlIndex = (0, _hooks.useEsqlIndex)(defineStepData.queryBar.query.query, ruleType, defineStepForm.isValid);
  const memoizedIndex = (0, _react.useMemo)(() => isEsqlRuleValue ? esqlIndex : defineStepData.index, [defineStepData.index, esqlIndex, isEsqlRuleValue]);
  const defineFieldsTransform = (0, _use_experimental_feature_fields_transform.useExperimentalFeatureFieldsTransform)();
  const isPreviewDisabled = (0, _helpers3.getIsRulePreviewDisabled)({
    ruleType,
    isQueryBarValid,
    isThreatQueryBarValid,
    index: memoizedIndex,
    dataViewId: defineStepData.dataViewId,
    dataSourceType: defineStepData.dataSourceType,
    threatIndex: defineStepData.threatIndex,
    threatMapping: defineStepData.threatMapping,
    machineLearningJobId: defineStepData.machineLearningJobId,
    queryBar: defineStepData.queryBar,
    newTermsFields: defineStepData.newTermsFields
  });
  (0, _react.useEffect)(() => {
    if (prevRuleType !== ruleType) {
      aboutStepForm.updateFieldValues({
        threatIndicatorPath: isThreatMatchRuleValue ? _constants.DEFAULT_INDICATOR_SOURCE_PATH : undefined
      });
      scheduleStepForm.updateFieldValues(isThreatMatchRuleValue ? _utils2.defaultThreatMatchSchedule : _utils2.defaultSchedule);
      setPrevRuleType(ruleType);
    }
  }, [aboutStepForm, scheduleStepForm, isThreatMatchRuleValue, prevRuleType, ruleType]);
  const {
    starting: isStartingJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  (0, _react.useEffect)(() => {
    const fetchDV = async () => {
      const dataViewsRefs = await dataViews.getIdsWithTitle();
      const dataViewIdIndexPatternMap = dataViewsRefs.reduce((acc, item) => ({
        ...acc,
        [item.id]: item
      }), {});
      setDataViewOptions(dataViewIdIndexPatternMap);
    };
    fetchDV();
  }, [dataViews]);
  const {
    indexPattern,
    isIndexPatternLoading,
    browserFields
  } = (0, _form.useRuleIndexPattern)({
    dataSourceType: defineStepData.dataSourceType,
    index: memoizedIndex,
    dataViewId: defineStepData.dataViewId
  });
  const rulesUrl = (0, _redirect_to_detection_engine.getRulesUrl)();
  const backOptions = (0, _react.useMemo)(() => ({
    path: rulesUrl,
    text: i18n.BACK_TO_RULES,
    pageId: _types2.SecurityPageName.rules
  }), [rulesUrl]);
  const handleAccordionToggle = (0, _react.useCallback)((step, isOpen) => setOpenSteps(_openSteps => ({
    ..._openSteps,
    [step]: isOpen
  })), []);
  const toggleDefineStep = (0, _react.useCallback)(isOpen => handleAccordionToggle(_types.RuleStep.defineRule, isOpen), [handleAccordionToggle]);
  const toggleAboutStep = (0, _react.useCallback)(isOpen => handleAccordionToggle(_types.RuleStep.aboutRule, isOpen), [handleAccordionToggle]);
  const toggleScheduleStep = (0, _react.useCallback)(isOpen => handleAccordionToggle(_types.RuleStep.scheduleRule, isOpen), [handleAccordionToggle]);
  const toggleActionsStep = (0, _react.useCallback)(isOpen => handleAccordionToggle(_types.RuleStep.ruleActions, isOpen), [handleAccordionToggle]);
  const goToStep = (0, _react.useCallback)(step => {
    if (_utils2.ruleStepsOrder.indexOf(step) > _utils2.ruleStepsOrder.indexOf(activeStep) && !openSteps[step]) {
      toggleStepAccordion(step);
    }
    setActiveStep(step);
  }, [activeStep, openSteps]);
  const toggleStepAccordion = step => {
    if (step === _types.RuleStep.defineRule) {
      var _defineRuleRef$curren;
      (_defineRuleRef$curren = defineRuleRef.current) === null || _defineRuleRef$curren === void 0 ? void 0 : _defineRuleRef$curren.onToggle();
    } else if (step === _types.RuleStep.aboutRule) {
      var _aboutRuleRef$current;
      (_aboutRuleRef$current = aboutRuleRef.current) === null || _aboutRuleRef$current === void 0 ? void 0 : _aboutRuleRef$current.onToggle();
    } else if (step === _types.RuleStep.scheduleRule) {
      var _scheduleRuleRef$curr;
      (_scheduleRuleRef$curr = scheduleRuleRef.current) === null || _scheduleRuleRef$curr === void 0 ? void 0 : _scheduleRuleRef$curr.onToggle();
    } else if (step === _types.RuleStep.ruleActions) {
      var _ruleActionsRef$curre;
      (_ruleActionsRef$curre = ruleActionsRef.current) === null || _ruleActionsRef$curre === void 0 ? void 0 : _ruleActionsRef$curre.onToggle();
    }
  };
  const validateStep = (0, _react.useCallback)(async step => {
    switch (step) {
      case _types.RuleStep.defineRule:
        return defineStepForm.validate();
      case _types.RuleStep.aboutRule:
        return aboutStepForm.validate();
      case _types.RuleStep.scheduleRule:
        return scheduleStepForm.validate();
      case _types.RuleStep.ruleActions:
        return actionsStepForm.validate();
    }
  }, [aboutStepForm, actionsStepForm, defineStepForm, scheduleStepForm]);
  const editStep = (0, _react.useCallback)(async step => {
    const valid = await validateStep(activeStep);
    if (valid) {
      goToStep(step);
    }
  }, [activeStep, validateStep, goToStep]);
  const submitRule = (0, _react.useCallback)(async (step, enabled) => {
    const valid = await validateStep(step);
    if (valid) {
      const localDefineStepData = defineFieldsTransform({
        ...defineStepForm.getFormData(),
        eqlOptions: eqlOptionsSelected
      });
      const localAboutStepData = aboutStepForm.getFormData();
      const localScheduleStepData = scheduleStepForm.getFormData();
      const localActionsStepData = actionsStepForm.getFormData();
      const startMlJobsIfNeeded = async () => {
        if (!(0, _utils.isMlRule)(ruleType) || !enabled) {
          return;
        }
        await startMlJobs(localDefineStepData.machineLearningJobId);
      };
      const [, createdRule] = await Promise.all([startMlJobsIfNeeded(), createRule((0, _helpers2.formatRule)(localDefineStepData, localAboutStepData, localScheduleStepData, {
        ...localActionsStepData,
        enabled
      }))]);
      addSuccess(i18n.SUCCESSFULLY_CREATED_RULES(createdRule.name));
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types2.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(createdRule.id)
      });
    }
  }, [validateStep, defineStepForm, eqlOptionsSelected, aboutStepForm, scheduleStepForm, actionsStepForm, createRule, addSuccess, navigateToApp, ruleType, startMlJobs, defineFieldsTransform]);
  const defineRuleButtonType = activeStep === _types.RuleStep.defineRule ? 'active' : defineStepForm.isValid ? 'valid' : 'passive';
  const defineRuleButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "1",
    title: RuleI18n.DEFINE_RULE,
    type: defineRuleButtonType
  }), [defineRuleButtonType]);
  const defineRuleNextStep = (0, _react.useCallback)(async () => {
    const valid = await defineStepForm.validate();
    if (valid) {
      const nextStep = getNextStep(_types.RuleStep.defineRule);
      if (nextStep) {
        goToStep(nextStep);
      }
    }
  }, [defineStepForm, goToStep]);
  const aboutRuleButtonType = activeStep === _types.RuleStep.aboutRule ? 'active' : aboutStepForm.isValid ? 'valid' : 'passive';
  const aboutRuleButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "2",
    title: RuleI18n.ABOUT_RULE,
    type: aboutRuleButtonType
  }), [aboutRuleButtonType]);
  const aboutRuleNextStep = (0, _react.useCallback)(async () => {
    const valid = await aboutStepForm.validate();
    if (valid) {
      const nextStep = getNextStep(_types.RuleStep.aboutRule);
      if (nextStep) {
        goToStep(nextStep);
      }
    }
  }, [aboutStepForm, goToStep]);
  const scheduleRuleButtonType = activeStep === _types.RuleStep.scheduleRule ? 'active' : scheduleStepForm.isValid ? 'valid' : 'passive';
  const scheduleRuleButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "3",
    title: RuleI18n.SCHEDULE_RULE,
    type: scheduleRuleButtonType
  }), [scheduleRuleButtonType]);
  const scheduleRuleNextStep = (0, _react.useCallback)(async () => {
    const valid = await scheduleStepForm.validate();
    if (valid) {
      const nextStep = getNextStep(_types.RuleStep.scheduleRule);
      if (nextStep) {
        goToStep(nextStep);
      }
    }
  }, [scheduleStepForm, goToStep]);
  const actionsRuleButtonType = activeStep === _types.RuleStep.ruleActions ? 'active' : actionsStepForm.isValid ? 'valid' : 'passive';
  const ruleActionsButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_accordion_title.AccordionTitle, {
    name: "4",
    title: RuleI18n.RULE_ACTIONS,
    type: actionsRuleButtonType
  }), [actionsRuleButtonType]);
  const submitRuleDisabled = (0, _react.useCallback)(() => {
    submitRule(_types.RuleStep.ruleActions, false);
  }, [submitRule]);
  const submitRuleEnabled = (0, _react.useCallback)(() => {
    submitRule(_types.RuleStep.ruleActions, true);
  }, [submitRule]);
  const memoDefineStepReadOnly = (0, _react.useMemo)(() => activeStep !== _types.RuleStep.defineRule && /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRuleReadOnly, {
    addPadding: true,
    defaultValues: defineStepData,
    descriptionColumns: "singleSplit",
    indexPattern: indexPattern
  }), [activeStep, defineStepData, indexPattern]);
  const memoStepDefineRule = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.defineRule ? undefined : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_step_define_rule.StepDefineRule, {
    isLoading: isCreateRuleLoading || loading,
    kibanaDataViews: dataViewOptions,
    indicesConfig: indicesConfig,
    threatIndicesConfig: threatIndicesConfig,
    form: defineStepForm,
    optionsSelected: eqlOptionsSelected,
    setOptionsSelected: setEqlOptionsSelected,
    indexPattern: indexPattern,
    isIndexPatternLoading: isIndexPatternLoading,
    browserFields: browserFields,
    isQueryBarValid: isQueryBarValid,
    setIsQueryBarValid: setIsQueryBarValid,
    setIsThreatQueryBarValid: setIsThreatQueryBarValid,
    ruleType: defineStepData.ruleType,
    index: memoizedIndex,
    threatIndex: defineStepData.threatIndex,
    groupByFields: defineStepData.groupByFields,
    dataSourceType: defineStepData.dataSourceType,
    shouldLoadQueryDynamically: defineStepData.shouldLoadQueryDynamically,
    queryBarTitle: defineStepData.queryBar.title,
    queryBarSavedId: defineStepData.queryBar.saved_id,
    thresholdFields: defineStepData.threshold.field,
    enableThresholdSuppression: defineStepData.enableThresholdSuppression
  }), /*#__PURE__*/_react.default.createElement(_next_step.NextStep, {
    dataTestSubj: "define-continue",
    onClick: defineRuleNextStep,
    isDisabled: isCreateRuleLoading
  })), memoDefineStepReadOnly), [activeStep, browserFields, dataViewOptions, defineRuleNextStep, defineStepData.dataSourceType, defineStepData.groupByFields, memoizedIndex, defineStepData.queryBar.saved_id, defineStepData.queryBar.title, defineStepData.ruleType, defineStepData.shouldLoadQueryDynamically, defineStepData.threatIndex, defineStepForm, eqlOptionsSelected, indexPattern, indicesConfig, isCreateRuleLoading, isIndexPatternLoading, isQueryBarValid, loading, memoDefineStepReadOnly, setEqlOptionsSelected, threatIndicesConfig, defineStepData.threshold.field, defineStepData.enableThresholdSuppression]);
  const memoDefineStepExtraAction = (0, _react.useMemo)(() => defineStepForm.isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-define-rule",
    iconType: "pencil",
    size: "xs",
    onClick: () => editStep(_types.RuleStep.defineRule)
  }, i18n.EDIT_RULE), [defineStepForm.isValid, editStep]);
  const memoAboutStepReadOnly = (0, _react.useMemo)(() => activeStep !== _types.RuleStep.aboutRule && /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRuleReadOnly, {
    addPadding: true,
    defaultValues: aboutStepData,
    descriptionColumns: "singleSplit"
  }), [aboutStepData, activeStep]);
  const memoStepAboutRule = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.aboutRule ? undefined : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_step_about_rule.StepAboutRule, {
    ruleType: defineStepData.ruleType,
    machineLearningJobId: defineStepData.machineLearningJobId,
    index: memoizedIndex,
    dataViewId: defineStepData.dataViewId,
    timestampOverride: aboutStepData.timestampOverride,
    isLoading: isCreateRuleLoading || loading,
    form: aboutStepForm,
    esqlQuery: esqlQueryForAboutStep
  }), /*#__PURE__*/_react.default.createElement(_next_step.NextStep, {
    dataTestSubj: "about-continue",
    onClick: aboutRuleNextStep,
    isDisabled: isCreateRuleLoading
  })), memoAboutStepReadOnly), [aboutRuleNextStep, aboutStepData.timestampOverride, aboutStepForm, activeStep, defineStepData.dataViewId, memoizedIndex, defineStepData.machineLearningJobId, defineStepData.ruleType, isCreateRuleLoading, loading, memoAboutStepReadOnly, esqlQueryForAboutStep]);
  const memoAboutStepExtraAction = (0, _react.useMemo)(() => aboutStepForm.isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-about-rule",
    iconType: "pencil",
    size: "xs",
    onClick: () => editStep(_types.RuleStep.aboutRule)
  }, i18n.EDIT_RULE), [aboutStepForm.isValid, editStep]);
  const memoStepScheduleRule = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.scheduleRule ? undefined : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRule, {
    isLoading: isCreateRuleLoading || loading,
    form: scheduleStepForm
  }), /*#__PURE__*/_react.default.createElement(_next_step.NextStep, {
    dataTestSubj: "schedule-continue",
    onClick: scheduleRuleNextStep,
    isDisabled: isCreateRuleLoading
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.scheduleRule ? 'none' : undefined
    }
  }, /*#__PURE__*/_react.default.createElement(_step_schedule_rule.StepScheduleRuleReadOnly, {
    addPadding: true,
    descriptionColumns: "singleSplit",
    defaultValues: scheduleStepData
  }))), [activeStep, isCreateRuleLoading, loading, scheduleRuleNextStep, scheduleStepData, scheduleStepForm]);
  const memoScheduleStepExtraAction = (0, _react.useMemo)(() => scheduleStepForm.isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "xs",
    onClick: () => editStep(_types.RuleStep.scheduleRule)
  }, i18n.EDIT_RULE), [editStep, scheduleStepForm.isValid]);
  const memoStepRuleActions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.ruleActions ? undefined : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActions, {
    isLoading: isCreateRuleLoading || loading || isStartingJobs,
    actionMessageParams: actionMessageParams,
    summaryActionMessageParams: actionMessageParams,
    ruleType: ruleType,
    form: actionsStepForm
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: false,
    isDisabled: isCreateRuleLoading,
    isLoading: isCreateRuleLoading,
    onClick: submitRuleDisabled,
    "data-test-subj": "create-enabled-false"
  }, i18n.COMPLETE_WITHOUT_ENABLING)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: isCreateRuleLoading,
    isLoading: isCreateRuleLoading,
    onClick: submitRuleEnabled,
    "data-test-subj": "create-enable"
  }, i18n.COMPLETE_WITH_ENABLING)))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: activeStep === _types.RuleStep.ruleActions ? 'none' : undefined
    }
  }, /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActionsReadOnly, {
    addPadding: true,
    defaultValues: actionsStepData
  }))), [actionMessageParams, actionsStepData, actionsStepForm, activeStep, isCreateRuleLoading, isStartingJobs, loading, ruleType, submitRuleDisabled, submitRuleEnabled]);
  const memoActionsStepExtraAction = (0, _react.useMemo)(() => actionsStepForm.isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "xs",
    onClick: () => editStep(_types.RuleStep.ruleActions)
  }, i18n.EDIT_RULE), [actionsStepForm.isValid, editStep]);
  const onToggleCollapsedMemo = (0, _react.useCallback)(() => setIsRulePreviewVisible(isVisible => !isVisible), []);
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  } else if (!(0, _privileges.hasUserCRUDPermission)(canUserCRUD)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRulesUrl)()
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, null, (EuiResizablePanel, EuiResizableButton, {
    togglePanel
  }) => {
    collapseFn.current = () => togglePanel === null || togglePanel === void 0 ? void 0 : togglePanel('preview', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      initialSize: 70,
      minSize: '40%',
      mode: "main"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_helpers.MaxWidthEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.CustomHeaderPageMemo, {
      backOptions: backOptions,
      isLoading: isCreateRuleLoading || loading,
      title: i18n.PAGE_TITLE,
      isRulePreviewVisible: isRulePreviewVisible,
      setIsRulePreviewVisible: setIsRulePreviewVisible,
      togglePanel: togglePanel
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      zindex: 4,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
      initialIsOpen: true,
      id: _types.RuleStep.defineRule,
      buttonContent: defineRuleButton,
      paddingSize: "xs",
      ref: defineRuleRef,
      onToggle: toggleDefineStep,
      extraAction: memoDefineStepExtraAction
    }, memoStepDefineRule)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 3
    }, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.aboutRule,
      buttonContent: aboutRuleButton,
      paddingSize: "xs",
      ref: aboutRuleRef,
      onToggle: toggleAboutStep,
      extraAction: memoAboutStepExtraAction
    }, memoStepAboutRule)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 2
    }, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.scheduleRule,
      buttonContent: scheduleRuleButton,
      paddingSize: "xs",
      ref: scheduleRuleRef,
      onToggle: toggleScheduleStep,
      extraAction: memoScheduleStepExtraAction
    }, memoStepScheduleRule)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(MyEuiPanel, {
      hasBorder: true,
      zindex: 1
    }, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
      initialIsOpen: false,
      id: _types.RuleStep.ruleActions,
      buttonContent: ruleActionsButton,
      paddingSize: "xs",
      ref: ruleActionsRef,
      onToggle: toggleActionsStep,
      extraAction: memoActionsStepExtraAction
    }, memoStepRuleActions))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: 'preview',
      mode: "collapsible",
      initialSize: 30,
      minSize: '20%',
      onToggleCollapsed: onToggleCollapsedMemo
    }, /*#__PURE__*/_react.default.createElement(_rule_preview.RulePreview, {
      isDisabled: isPreviewDisabled && activeStep === _types.RuleStep.defineRule,
      defineRuleData: defineStepData,
      aboutRuleData: aboutStepData,
      scheduleRuleData: scheduleStepData
    })));
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.rulesCreate
  }));
};
const CreateRulePage = exports.CreateRulePage = /*#__PURE__*/_react.default.memo(CreateRulePageComponent);
const MemoEuiAccordion = /*#__PURE__*/(0, _react.memo)(_eui.EuiAccordion);