"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigationFields = void 0;
var _react = require("react");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _get_esql_query_config = require("../../rule_creation/logic/get_esql_query_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlToFields = data => {
  var _data$columns;
  if (data && 'error' in data) {
    return [];
  }
  const fields = ((_data$columns = data === null || data === void 0 ? void 0 : data.columns) !== null && _data$columns !== void 0 ? _data$columns : []).map(({
    id,
    meta
  }) => {
    return {
      name: id,
      type: meta.type
    };
  });
  return fields;
};
/**
 * fetches ES|QL fields and convert them to DataViewBase fields
 */
const useEsqlFields = esqlQuery => {
  const kibana = (0, _public.useKibana)();
  const {
    expressions
  } = kibana.services;
  const queryConfig = (0, _get_esql_query_config.getEsqlQueryConfig)({
    esqlQuery,
    expressions
  });
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)(queryConfig);
  const fields = (0, _react.useMemo)(() => {
    return esqlToFields(data);
  }, [data]);
  return {
    fields,
    isLoading
  };
};
const useInvestigationFields = ({
  esqlQuery,
  indexPatternsFields
}) => {
  const {
    fields: esqlFields,
    isLoading
  } = useEsqlFields(esqlQuery);
  const investigationFields = (0, _react.useMemo)(() => {
    if (!esqlQuery) {
      return indexPatternsFields;
    }

    // alerts generated from non-aggregating queries are enriched with source document
    // so, index patterns fields should be included in the list of investigation fields
    const isEsqlQueryAggregating = (0, _securitysolutionUtils.computeIsESQLQueryAggregating)(esqlQuery);
    return isEsqlQueryAggregating ? esqlFields : [...esqlFields, ...indexPatternsFields];
  }, [esqlFields, esqlQuery, indexPatternsFields]);
  return {
    investigationFields,
    isLoading
  };
};
exports.useInvestigationFields = useInvestigationFields;