"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _threat_match = require("../../../../common/components/threat_match");
var _shared_imports = require("../../../../shared_imports");
var _schema = require("../step_define_rule/schema");
var _query_bar = require("../query_bar");
var i18n = _interopRequireWildcard(require("../step_define_rule/translations"));
var _step_define_rule = require("../step_define_rule");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const ThreatMatchInputComponent = ({
  threatIndexModified,
  handleResetThreatIndices,
  threatMapping,
  indexPatterns,
  threatIndexPatterns,
  threatIndexPatternsLoading,
  threatBrowserFields,
  onValidityChange
}) => {
  const {
    setValue,
    value: threatItems
  } = threatMapping;
  const {
    isInvalid: isThreatMappingInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(threatMapping);
  const [isThreatIndexPatternValid, setIsThreatIndexPatternValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (onValidityChange) {
      onValidityChange(!isThreatMappingInvalid && isThreatIndexPatternValid);
    }
  }, [isThreatIndexPatternValid, isThreatMappingInvalid, onValidityChange]);
  const handleBuilderOnChange = (0, _react.useCallback)(({
    entryItems
  }) => {
    setValue(entryItems);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "threatIndex",
    config: {
      ..._schema.schema.threatIndex,
      labelAppend: threatIndexModified ? /*#__PURE__*/_react.default.createElement(_step_define_rule.MyLabelButton, {
        onClick: handleResetThreatIndices,
        iconType: "refresh"
      }, i18n.RESET_DEFAULT_INDEX) : null
    },
    componentProps: {
      idAria: 'detectionEngineStepDefineRuleThreatMatchIndices',
      'data-test-subj': 'detectionEngineStepDefineRuleThreatMatchIndices',
      euiFieldProps: {
        fullWidth: true,
        isDisabled: false,
        placeholder: ''
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "threatQueryBar",
    config: {
      ..._schema.schema.threatQueryBar,
      labelAppend: null
    },
    component: _query_bar.QueryBarDefineRule,
    componentProps: {
      browserFields: threatBrowserFields,
      idAria: 'detectionEngineStepDefineThreatRuleQueryBar',
      indexPattern: threatIndexPatterns,
      isDisabled: false,
      isLoading: threatIndexPatternsLoading,
      dataTestSubj: 'detectionEngineStepDefineThreatRuleQueryBar',
      openTimelineSearch: false,
      onValidityChange: setIsThreatIndexPatternValid
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: threatMapping.label,
    labelAppend: threatMapping.labelAppend,
    helpText: threatMapping.helpText,
    error: errorMessage,
    isInvalid: isThreatMappingInvalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_threat_match.ThreatMatchComponent, {
    listItems: threatItems,
    indexPatterns: indexPatterns,
    threatIndexPatterns: threatIndexPatterns,
    "data-test-subj": "threatmatch-builder",
    "id-aria": "threatmatch-builder",
    onChange: handleBuilderOnChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const ThreatMatchInput = exports.ThreatMatchInput = /*#__PURE__*/_react.default.memo(ThreatMatchInputComponent);