"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressionInfoIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POPOVER_WIDTH = 320;

/**
 * Icon and popover that gives hint to users how suppression for missing fields work
 */
const SuppressionInfoIconComponent = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const onButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "questionInCircle",
    onClick: onButtonClick,
    "aria-label": "Open help popover"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: POPOVER_WIDTH
    },
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsTooltipContent",
    defaultMessage: "Choose how to handle events with missing {suppressBy} fields. Either group events with missing fields together, or create a separate alert for each event. {learnMoreLink}",
    values: {
      suppressBy: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsTooltipSuppressByDescription",
        defaultMessage: "Suppress alerts by"
      })),
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.siem.configureAlertSuppression,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsTooltipLink",
        defaultMessage: "Learn more"
      }))
    }
  })));
};
const SuppressionInfoIcon = exports.SuppressionInfoIcon = /*#__PURE__*/_react.default.memo(SuppressionInfoIconComponent);
SuppressionInfoIcon.displayName = 'SuppressionInfoIcon';