"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewTermsFieldsComponent = exports.NewTermsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_COMBO_BOX_WIDTH = 410;
const fieldDescribedByIds = 'detectionEngineStepDefineRuleNewTermsField';
const NewTermsFieldsComponent = ({
  browserFields,
  field
}) => {
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(browserField => ({
      label: browserField.name
    })),
    placeholder: _translations.NEW_TERMS_FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    style: {
      width: `${FIELD_COMBO_BOX_WIDTH}px`
    }
  }), [browserFields]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: field,
    idAria: fieldDescribedByIds,
    euiFieldProps: fieldEuiFieldProps
  });
};
exports.NewTermsFieldsComponent = NewTermsFieldsComponent;
const NewTermsFields = exports.NewTermsFields = /*#__PURE__*/_react.default.memo(NewTermsFieldsComponent);