"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewSelector = ({
  kibanaDataViews,
  field
}) => {
  let isInvalid;
  let errorMessage;
  let dataViewId;
  if (field != null) {
    const fieldAndError = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    isInvalid = fieldAndError.isInvalid;
    errorMessage = fieldAndError.errorMessage;
    dataViewId = field.value;
  }
  const kibanaDataViewsDefined = (0, _react.useMemo)(() => kibanaDataViews != null && Object.keys(kibanaDataViews).length > 0, [kibanaDataViews]);

  // Most likely case here is that a data view of an existing rule was deleted
  // and can no longer be found
  const selectedDataViewNotFound = (0, _react.useMemo)(() => dataViewId != null && dataViewId !== '' && kibanaDataViewsDefined && !Object.hasOwn(kibanaDataViews, dataViewId), [kibanaDataViewsDefined, dataViewId, kibanaDataViews]);
  const [selectedOption, setSelectedOption] = (0, _react.useState)(!selectedDataViewNotFound && dataViewId != null && dataViewId !== '' ? [{
    id: kibanaDataViews[dataViewId].id,
    label: kibanaDataViews[dataViewId].title
  }] : []);
  const [showDataViewAlertsOnAlertsWarning, setShowDataViewAlertsOnAlertsWarning] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!selectedDataViewNotFound && dataViewId) {
      const dataViewsTitle = kibanaDataViews[dataViewId].title;
      const dataViewsId = kibanaDataViews[dataViewId].id;
      setShowDataViewAlertsOnAlertsWarning(dataViewsId === 'security-solution-default');
      setSelectedOption([{
        id: dataViewsId,
        label: dataViewsTitle
      }]);
    } else {
      setSelectedOption([]);
    }
  }, [dataViewId, field, kibanaDataViews, selectedDataViewNotFound, setShowDataViewAlertsOnAlertsWarning]);

  // TODO: optimize this, pass down array of data view ids
  // at the same time we grab the data views in the top level form component
  const dataViewOptions = (0, _react.useMemo)(() => {
    return kibanaDataViewsDefined ? Object.values(kibanaDataViews).map(dv => ({
      label: dv.title,
      id: dv.id
    })) : [];
  }, [kibanaDataViewsDefined, kibanaDataViews]);
  const onChangeDataViews = options => {
    const selectedDataViewOption = options;
    setSelectedOption(selectedDataViewOption !== null && selectedDataViewOption !== void 0 ? selectedDataViewOption : []);
    if (selectedDataViewOption != null && selectedDataViewOption.length > 0 && selectedDataViewOption[0].id != null) {
      const selectedDataViewId = selectedDataViewOption[0].id;
      field === null || field === void 0 ? void 0 : field.setValue(selectedDataViewId);
    } else {
      field === null || field === void 0 ? void 0 : field.setValue(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedDataViewNotFound && dataViewId != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.DATA_VIEW_NOT_FOUND_WARNING_LABEL,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION(dataViewId))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), showDataViewAlertsOnAlertsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.DDATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL,
    color: "warning",
    iconType: "help",
    "data-test-subj": "defaultSecurityDataViewWarning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field === null || field === void 0 ? void 0 : field.label,
    helpText: field === null || field === void 0 ? void 0 : field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    "data-test-subj": "pick-rule-data-source"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: true,
    singleSelection: {
      asPlainText: true
    },
    onChange: onChangeDataViews,
    options: dataViewOptions,
    selectedOptions: selectedOption,
    "aria-label": i18n.PICK_INDEX_PATTERNS,
    placeholder: i18n.PICK_INDEX_PATTERNS,
    "data-test-subj": "detectionsDataViewSelectorDropdown"
  })));
};
exports.DataViewSelector = DataViewSelector;