"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlValidator = exports.computeHasMetadataOperator = exports.ERROR_CODES = void 0;
var _lodash = require("lodash");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _kibana = require("../../../common/lib/kibana");
var _query_client_provider = require("../../../common/containers/query_client/query_client_provider");
var _utils = require("../../../../common/detection_engine/utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _get_esql_query_config = require("./get_esql_query_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ERROR_CODES = exports.ERROR_CODES = /*#__PURE__*/function (ERROR_CODES) {
  ERROR_CODES["INVALID_ESQL"] = "ERR_INVALID_ESQL";
  ERROR_CODES["ERR_MISSING_ID_FIELD_FROM_RESULT"] = "ERR_MISSING_ID_FIELD_FROM_RESULT";
  return ERROR_CODES;
}({});
const constructValidationError = error => {
  return {
    code: ERROR_CODES.INVALID_ESQL,
    message: error !== null && error !== void 0 && error.message ? i18n.esqlValidationErrorMessage(error.message) : i18n.ESQL_VALIDATION_UNKNOWN_ERROR,
    error
  };
};

/**
 * checks whether query has metadata _id operator
 */
const computeHasMetadataOperator = esqlQuery => {
  var _esqlQuery$split;
  return /(?<!\|[\s\S.]*)\s*metadata[\s\S.]*_id[\s\S.]*/i.test(esqlQuery === null || esqlQuery === void 0 ? void 0 : (_esqlQuery$split = esqlQuery.split('|')) === null || _esqlQuery$split === void 0 ? void 0 : _esqlQuery$split[0]);
};

/**
 * form validator for ES|QL queryBar
 */
exports.computeHasMetadataOperator = computeHasMetadataOperator;
const esqlValidator = async (...args) => {
  const [{
    value,
    formData
  }] = args;
  const {
    query: queryValue
  } = value;
  const query = queryValue.query;
  const {
    ruleType
  } = formData;
  const needsValidation = (0, _utils.isEsqlRule)(ruleType) && !(0, _lodash.isEmpty)(query);
  if (!needsValidation) {
    return;
  }
  try {
    var _data$columns;
    const services = _kibana.KibanaServices.get();
    const isEsqlQueryAggregating = (0, _securitysolutionUtils.computeIsESQLQueryAggregating)(query);

    // non-aggregating query which does not have metadata, is not a valid one
    if (!isEsqlQueryAggregating && !computeHasMetadataOperator(query)) {
      return {
        code: ERROR_CODES.ERR_MISSING_ID_FIELD_FROM_RESULT,
        message: i18n.ESQL_VALIDATION_MISSING_ID_IN_QUERY_ERROR
      };
    }
    const data = await _query_client_provider.securitySolutionQueryClient.fetchQuery((0, _get_esql_query_config.getEsqlQueryConfig)({
      esqlQuery: query,
      expressions: services.expressions
    }));
    if (data && 'error' in data) {
      return constructValidationError(data.error);
    }

    // check whether _id field is present in response
    const isIdFieldPresent = ((_data$columns = data === null || data === void 0 ? void 0 : data.columns) !== null && _data$columns !== void 0 ? _data$columns : []).find(({
      id
    }) => '_id' === id);
    // for non-aggregating query, we want to disable queries w/o _id property returned in response
    if (!isEsqlQueryAggregating && !isIdFieldPresent) {
      return {
        code: ERROR_CODES.ERR_MISSING_ID_FIELD_FROM_RESULT,
        message: i18n.ESQL_VALIDATION_MISSING_ID_IN_QUERY_ERROR
      };
    }
  } catch (error) {
    return constructValidationError(error);
  }
};
exports.esqlValidator = esqlValidator;