"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpTextWarningContainer = _styledComponents.default.div`
  margin-top: 10px;
`;
const HelpTextComponent = ({
  href,
  notRunningJobIds
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.machineLearningJobIdHelpText",
  defaultMessage: "We've provided a few common jobs to get you started. To add your own custom jobs, assign a group of 'security' to those jobs in the {machineLearning} application to make them appear here.",
  values: {
    machineLearning: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: href,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.components.mlJobSelect.machineLearningLink",
      defaultMessage: "Machine Learning"
    }))
  }
}), notRunningJobIds.length > 0 && /*#__PURE__*/_react.default.createElement(HelpTextWarningContainer, {
  "data-test-subj": "ml-warning-not-running-jobs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("span", null, notRunningJobIds.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.mlEnableJobSingle",
  defaultMessage: "The selected ML job, {jobName}, is not currently running. We will start {jobName} when you enable this rule.",
  values: {
    jobName: notRunningJobIds[0]
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.mlEnableJobMulti",
  defaultMessage: "The selected ML jobs, {jobNames}, are not currently running. We will start all of these jobs when you enable this rule.",
  values: {
    jobNames: notRunningJobIds.reduce((acc, value, i, array) => acc + (i < array.length - 1 ? ', ' : ', and ') + value)
  }
})))));
const HelpText = exports.HelpText = /*#__PURE__*/_react.default.memo(HelpTextComponent);