"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialSourcererState = exports.initSourcererScope = exports.initDataView = exports.SourcererScopeName = void 0;
var _common = require("@kbn/timelines-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** Uniquely identifies a Sourcerer Scope */
let SourcererScopeName = exports.SourcererScopeName = /*#__PURE__*/function (SourcererScopeName) {
  SourcererScopeName["default"] = "default";
  SourcererScopeName["detections"] = "detections";
  SourcererScopeName["timeline"] = "timeline";
  SourcererScopeName["analyzer"] = "analyzer";
  return SourcererScopeName;
}({});
/**
 * Data related to each sourcerer scope
 */
/**
 * DataView from Kibana + timelines/index_fields enhanced field data
 */
/**
 * Combined data from SourcererDataView and SourcererScope to create
 * selected data view state
 */
/**
 * sourcerer model for redux
 */
const initSourcererScope = exports.initSourcererScope = {
  loading: false,
  selectedDataViewId: null,
  selectedPatterns: [],
  missingPatterns: []
};
const initDataView = exports.initDataView = {
  browserFields: _common.EMPTY_BROWSER_FIELDS,
  id: '',
  indexFields: _common.EMPTY_INDEX_FIELDS,
  fields: undefined,
  loading: false,
  patternList: [],
  runtimeMappings: {},
  title: '',
  dataView: undefined
};
const initialSourcererState = exports.initialSourcererState = {
  defaultDataView: initDataView,
  kibanaDataViews: [],
  signalIndexName: null,
  signalIndexMappingOutdated: null,
  sourcererScopes: {
    [SourcererScopeName.default]: {
      ...initSourcererScope,
      id: SourcererScopeName.default
    },
    [SourcererScopeName.detections]: {
      ...initSourcererScope,
      id: SourcererScopeName.detections
    },
    [SourcererScopeName.timeline]: {
      ...initSourcererScope,
      id: SourcererScopeName.timeline
    },
    [SourcererScopeName.analyzer]: {
      ...initSourcererScope,
      id: SourcererScopeName.analyzer
    }
  }
};