"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultHeaders = void 0;
var _default_headers = require("../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../timelines/components/timeline/body/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultHeaders = exports.defaultHeaders = [{
  category: 'base',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Date/time when the event originated.\nFor log events this is the date/time when the event was generated, and not when it was read.\nRequired field for all events.',
  example: '2016-05-23T08:05:34.853Z',
  id: '@timestamp',
  type: 'date',
  esTypes: ['date'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH
}, {
  category: 'event',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: "Severity describes the severity of the event. What the different severity values mean can very different between use cases. It's up to the implementer to make sure severities are consistent across events.",
  example: '7',
  id: 'event.severity',
  type: 'number',
  esTypes: ['long'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'event',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Event category.\nThis contains high-level information about the contents of the event. It is more generic than `event.action`, in the sense that typically a category contains multiple actions. Warning: In future versions of ECS, we plan to provide a list of acceptable values for this field, please use with caution.',
  example: 'user-management',
  id: 'event.category',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'event',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'The action captured by the event.\nThis describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.',
  example: 'user-password-change',
  id: 'event.action',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'host',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Name of the host.\nIt can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.',
  example: '',
  id: 'host.name',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'source',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'IP address of the source.\nCan be one or multiple IPv4 or IPv6 addresses.',
  example: '',
  id: 'source.ip',
  type: 'ip',
  esTypes: ['ip'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'destination',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'IP address of the destination.\nCan be one or multiple IPv4 or IPv6 addresses.',
  example: '',
  id: 'destination.ip',
  type: 'ip',
  esTypes: ['ip'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  aggregatable: true,
  category: 'destination',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Bytes sent from the source to the destination',
  example: '123',
  format: 'bytes',
  id: 'destination.bytes',
  type: 'number',
  esTypes: ['long'],
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'user',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Short name or login of the user.',
  example: 'albert',
  id: 'user.name',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'base',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'Each document has an _id that uniquely identifies it',
  example: 'Y-6TfmcB0WOhS6qyMv3s',
  id: '_id',
  type: 'string',
  esTypes: [],
  // empty for _id
  aggregatable: false,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}, {
  category: 'base',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  description: 'For log events the message field contains the log message.\nIn other use cases the message field can be used to concatenate different values which are then freely searchable. If multiple messages exist, they can be combined into one message.',
  example: 'Hello World',
  id: 'message',
  type: 'string',
  esTypes: ['text'],
  aggregatable: false,
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
}];