"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityInternalNavLinks = exports.useRootNavLink = exports.useNavLinks = exports.updateNavLinks = exports.navLinksUpdater$ = exports.navLinks$ = exports.internalNavLinks$ = exports.formatNavigationLinks = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _links = require("./links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formatNavigationLinks = appLinks => appLinks.map(link => {
  var _link$links;
  return {
    id: link.id,
    title: link.title,
    ...(link.categories != null && {
      categories: link.categories
    }),
    ...(link.description != null && {
      description: link.description
    }),
    ...(link.sideNavDisabled === true && {
      disabled: true
    }),
    ...(link.landingIcon != null && {
      landingIcon: link.landingIcon
    }),
    ...(link.landingImage != null && {
      landingImage: link.landingImage
    }),
    ...(link.sideNavIcon != null && {
      sideNavIcon: link.sideNavIcon
    }),
    ...(link.sideNavFooter != null && {
      isFooterLink: link.sideNavFooter
    }),
    ...(link.skipUrlState != null && {
      skipUrlState: link.skipUrlState
    }),
    ...(link.isBeta != null && {
      isBeta: link.isBeta
    }),
    ...(link.betaOptions != null && {
      betaOptions: link.betaOptions
    }),
    ...(((_link$links = link.links) === null || _link$links === void 0 ? void 0 : _link$links.length) && {
      links: formatNavigationLinks(link.links)
    })
  };
});

/**
 * Navigation links observable based on Security AppLinks,
 * It is used to generate the side navigation items
 */
exports.formatNavigationLinks = formatNavigationLinks;
const internalNavLinks$ = exports.internalNavLinks$ = _links.appLinks$.pipe((0, _rxjs.map)(formatNavigationLinks));
const navLinksUpdater$ = exports.navLinksUpdater$ = new _rxjs.BehaviorSubject([]);
const navLinks$ = exports.navLinks$ = navLinksUpdater$.asObservable();
let currentSubscription;
const updateNavLinks = (isSolutionNavEnabled, core) => {
  if (currentSubscription) {
    currentSubscription.unsubscribe();
  }
  if (isSolutionNavEnabled) {
    // import solution nav links only when solution nav is enabled
    lazySolutionNavLinks().then(createSolutionNavLinks$ => {
      currentSubscription = createSolutionNavLinks$(internalNavLinks$, core).subscribe(links => {
        navLinksUpdater$.next(links);
      });
    });
  } else {
    currentSubscription = internalNavLinks$.subscribe(links => {
      navLinksUpdater$.next(links);
    });
  }
};

// includes internal security links only
exports.updateNavLinks = updateNavLinks;
const useSecurityInternalNavLinks = () => {
  return (0, _useObservable.default)(internalNavLinks$, []);
};

// includes internal security links and externals links to other applications such as discover, ml, etc.
exports.useSecurityInternalNavLinks = useSecurityInternalNavLinks;
const useNavLinks = () => {
  return (0, _useObservable.default)(navLinks$, navLinksUpdater$.value); // use default value from updater subject to prevent re-renderings
};
exports.useNavLinks = useNavLinks;
const useRootNavLink = linkId => {
  return useNavLinks().find(({
    id
  }) => id === linkId);
};
exports.useRootNavLink = useRootNavLink;
const lazySolutionNavLinks = async () => Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "solution_nav_links" */
'../../app/solution_navigation/links/nav_links'))).then(({
  createSolutionNavLinks$
}) => createSolutionNavLinks$);