"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeepLinksUpdater = void 0;
var _rxjs = require("rxjs");
var _links = require("./links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: remove after rollout https://github.com/elastic/kibana/issues/179572
const classicFormatter = appLinks => appLinks.map(appLink => {
  var _appLink$visibleIn, _appLink$links;
  const visibleIn = new Set((_appLink$visibleIn = appLink.visibleIn) !== null && _appLink$visibleIn !== void 0 ? _appLink$visibleIn : []);
  if (!appLink.globalSearchDisabled) {
    visibleIn.add('globalSearch');
  }
  if (appLink.globalNavPosition != null) {
    visibleIn.add('sideNav');
  }
  const deepLink = {
    id: appLink.id,
    path: appLink.path,
    title: appLink.title,
    visibleIn: Array.from(visibleIn),
    ...(appLink.globalNavPosition != null ? {
      order: appLink.globalNavPosition
    } : {}),
    ...(appLink.globalSearchKeywords != null ? {
      keywords: appLink.globalSearchKeywords
    } : {}),
    ...(appLink.links && (_appLink$links = appLink.links) !== null && _appLink$links !== void 0 && _appLink$links.length ? {
      deepLinks: classicFormatter(appLink.links)
    } : {})
  };
  return deepLink;
});
const solutionFormatter = appLinks => appLinks.map(appLink => {
  var _appLink$visibleIn2, _appLink$links2;
  const visibleIn = new Set((_appLink$visibleIn2 = appLink.visibleIn) !== null && _appLink$visibleIn2 !== void 0 ? _appLink$visibleIn2 : []);
  if (!appLink.globalSearchDisabled) {
    visibleIn.add('globalSearch');
  }
  if (!appLink.sideNavDisabled) {
    visibleIn.add('sideNav');
  }
  const deepLink = {
    id: appLink.id,
    path: appLink.path,
    title: appLink.title,
    visibleIn: Array.from(visibleIn),
    ...(appLink.globalSearchKeywords != null ? {
      keywords: appLink.globalSearchKeywords
    } : {}),
    ...(appLink.links && (_appLink$links2 = appLink.links) !== null && _appLink$links2 !== void 0 && _appLink$links2.length ? {
      deepLinks: solutionFormatter(appLink.links)
    } : {})
  };
  return deepLink;
});

/**
 * Registers any change in appLinks to be updated in app deepLinks
 */
const registerDeepLinksUpdater = (appUpdater$, isSolutionNavigationEnabled$) => {
  return _links.appLinks$.pipe((0, _rxjs.combineLatestWith)(isSolutionNavigationEnabled$)).subscribe(([appLinks, isSolutionNavigationEnabled]) => {
    appUpdater$.next(() => ({
      deepLinks: isSolutionNavigationEnabled ? solutionFormatter(appLinks) : classicFormatter(appLinks)
    }));
  });
};
exports.registerDeepLinksUpdater = registerDeepLinksUpdater;