"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentDetailsTabClickedEvent = exports.DocumentDetailsFlyoutOpenedEvent = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentDetailsFlyoutOpenedEvent = exports.DocumentDetailsFlyoutOpenedEvent = {
  eventType: _constants.TelemetryEventTypes.DetailsFlyoutOpened,
  schema: {
    location: {
      type: 'text',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    panel: {
      type: 'keyword',
      _meta: {
        description: 'Panel (left|right|preview)',
        optional: false
      }
    }
  }
};
const DocumentDetailsTabClickedEvent = exports.DocumentDetailsTabClickedEvent = {
  eventType: _constants.TelemetryEventTypes.DetailsFlyoutTabClicked,
  schema: {
    location: {
      type: 'text',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    panel: {
      type: 'keyword',
      _meta: {
        description: 'Panel (left|right)',
        optional: false
      }
    },
    tabId: {
      type: 'keyword',
      _meta: {
        description: 'Tab ID',
        optional: false
      }
    }
  }
};