"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.TelemetryEventTypes = exports.TELEMETRY_EVENT = exports.ML_JOB_TELEMETRY_STATUS = void 0;
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TELEMETRY_EVENT = exports.TELEMETRY_EVENT = /*#__PURE__*/function (TELEMETRY_EVENT) {
  TELEMETRY_EVENT["SIEM_RULE_ENABLED"] = "siem_rule_enabled";
  TELEMETRY_EVENT["SIEM_RULE_DISABLED"] = "siem_rule_disabled";
  TELEMETRY_EVENT["CUSTOM_RULE_ENABLED"] = "custom_rule_enabled";
  TELEMETRY_EVENT["CUSTOM_RULE_DISABLED"] = "custom_rule_disabled";
  TELEMETRY_EVENT["SIEM_JOB_ENABLED"] = "siem_job_enabled";
  TELEMETRY_EVENT["SIEM_JOB_DISABLED"] = "siem_job_disabled";
  TELEMETRY_EVENT["CUSTOM_JOB_ENABLED"] = "custom_job_enabled";
  TELEMETRY_EVENT["CUSTOM_JOB_DISABLED"] = "custom_job_disabled";
  TELEMETRY_EVENT["JOB_ENABLE_FAILURE"] = "job_enable_failure";
  TELEMETRY_EVENT["JOB_DISABLE_FAILURE"] = "job_disable_failure";
  TELEMETRY_EVENT["TIMELINE_OPENED"] = "open_timeline";
  TELEMETRY_EVENT["TIMELINE_SAVED"] = "timeline_saved";
  TELEMETRY_EVENT["TIMELINE_NAMED"] = "timeline_named";
  TELEMETRY_EVENT["TAB_CLICKED"] = "tab_";
  TELEMETRY_EVENT["LANDING_CARD"] = "landing_card_";
  TELEMETRY_EVENT["DASHBOARD"] = "navigate_to_dashboard";
  TELEMETRY_EVENT["CREATE_DASHBOARD"] = "create_dashboard";
  TELEMETRY_EVENT["OPEN_VALUE_LIST_MODAL"] = "open_value_list_modal";
  TELEMETRY_EVENT["CREATE_VALUE_LIST_ITEM"] = "create_value_list_item";
  TELEMETRY_EVENT["DELETE_VALUE_LIST_ITEM"] = "delete_value_list_item";
  TELEMETRY_EVENT["EDIT_VALUE_LIST_ITEM"] = "edit_value_list_item";
  TELEMETRY_EVENT["ADDITIONAL_UPLOAD_VALUE_LIST_ITEM"] = "additinonal_upload_value_list_item";
  return TELEMETRY_EVENT;
}({});
let TelemetryEventTypes = exports.TelemetryEventTypes = /*#__PURE__*/function (TelemetryEventTypes) {
  TelemetryEventTypes["AlertsGroupingChanged"] = "Alerts Grouping Changed";
  TelemetryEventTypes["AlertsGroupingToggled"] = "Alerts Grouping Toggled";
  TelemetryEventTypes["AlertsGroupingTakeAction"] = "Alerts Grouping Take Action";
  TelemetryEventTypes["BreadcrumbClicked"] = "Breadcrumb Clicked";
  TelemetryEventTypes["AssistantInvoked"] = "Assistant Invoked";
  TelemetryEventTypes["AssistantMessageSent"] = "Assistant Message Sent";
  TelemetryEventTypes["AssistantQuickPrompt"] = "Assistant Quick Prompt";
  TelemetryEventTypes["AssistantSettingToggled"] = "Assistant Setting Toggled";
  TelemetryEventTypes["AssetCriticalityCsvPreviewGenerated"] = "Asset Criticality Csv Preview Generated";
  TelemetryEventTypes["AssetCriticalityFileSelected"] = "Asset Criticality File Selected";
  TelemetryEventTypes["AssetCriticalityCsvImported"] = "Asset Criticality CSV Imported";
  TelemetryEventTypes["AttackDiscoveriesGenerated"] = "Attack Discoveries Generated";
  TelemetryEventTypes["EntityDetailsClicked"] = "Entity Details Clicked";
  TelemetryEventTypes["EntityAlertsClicked"] = "Entity Alerts Clicked";
  TelemetryEventTypes["EntityRiskFiltered"] = "Entity Risk Filtered";
  TelemetryEventTypes["MLJobUpdate"] = "ML Job Update";
  TelemetryEventTypes["AddRiskInputToTimelineClicked"] = "Add Risk Input To Timeline Clicked";
  TelemetryEventTypes["ToggleRiskSummaryClicked"] = "Toggle Risk Summary Clicked";
  TelemetryEventTypes["RiskInputsExpandedFlyoutOpened"] = "Risk Inputs Expanded Flyout Opened";
  TelemetryEventTypes["CellActionClicked"] = "Cell Action Clicked";
  TelemetryEventTypes["AnomaliesCountClicked"] = "Anomalies Count Clicked";
  TelemetryEventTypes["DataQualityIndexChecked"] = "Data Quality Index Checked";
  TelemetryEventTypes["DataQualityCheckAllCompleted"] = "Data Quality Check All Completed";
  TelemetryEventTypes["DetailsFlyoutOpened"] = "Details Flyout Opened";
  TelemetryEventTypes["DetailsFlyoutTabClicked"] = "Details Flyout Tabs Clicked";
  TelemetryEventTypes["OnboardingHubStepOpen"] = "Onboarding Hub Step Open";
  TelemetryEventTypes["OnboardingHubStepFinished"] = "Onboarding Hub Step Finished";
  TelemetryEventTypes["OnboardingHubStepLinkClicked"] = "Onboarding Hub Step Link Clicked";
  return TelemetryEventTypes;
}({});
let ML_JOB_TELEMETRY_STATUS = exports.ML_JOB_TELEMETRY_STATUS = /*#__PURE__*/function (ML_JOB_TELEMETRY_STATUS) {
  ML_JOB_TELEMETRY_STATUS["started"] = "started";
  ML_JOB_TELEMETRY_STATUS["startError"] = "start_error";
  ML_JOB_TELEMETRY_STATUS["stopped"] = "stopped";
  ML_JOB_TELEMETRY_STATUS["stopError"] = "stop_error";
  ML_JOB_TELEMETRY_STATUS["moduleInstalled"] = "module_installed";
  ML_JOB_TELEMETRY_STATUS["installationError"] = "installationError";
  return ML_JOB_TELEMETRY_STATUS;
}({});