"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineSavePrompt = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _use_show_timeline_for_path = require("../../utils/timeline/use_show_timeline_for_path");
var _types = require("../../../../common/types");
var _timeline = require("../../../../common/api/timeline");
var _kibana = require("../../lib/kibana");
var _use_selector = require("../use_selector");
var _constants = require("../../../../common/constants");
var _selectors = require("../../../timelines/store/selectors");
var _store = require("../../../timelines/store");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Issue with history.block
// https://github.com/elastic/kibana/issues/132597

const useTimelineSavePrompt = (timelineId, onAppLeave) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    overlays,
    application,
    http
  } = (0, _kibana.useKibana)().services;
  const getIsTimelineVisible = (0, _use_show_timeline_for_path.useShowTimelineForGivenPath)();
  const history = (0, _reactRouterDom.useHistory)();
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    status: timelineStatus,
    updated,
    changed
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, timelineId));
  const showSaveTimelineModal = (0, _react.useCallback)(() => {
    dispatch(_store.timelineActions.showTimeline({
      id: timelineId,
      show: true
    }));
    dispatch(_store.timelineActions.setActiveTabTimeline({
      id: timelineId,
      activeTab: _types.TimelineTabs.query
    }));
    dispatch(_store.timelineActions.toggleModalSaveTimeline({
      id: timelineId,
      showModalSaveTimeline: true
    }));
  }, [dispatch, timelineId]);
  (0, _react.useEffect)(() => {
    const unblock = history.block(location => {
      const relativePath = location.pathname.replace(_constants.APP_PATH, '');
      async function confirmSaveTimeline() {
        const confirmRes = await (overlays === null || overlays === void 0 ? void 0 : overlays.openConfirm(_translations.UNSAVED_TIMELINE_SAVE_PROMPT, {
          title: _translations.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE,
          'data-test-subj': 'appLeaveConfirmModal'
        }));
        if (confirmRes) {
          unblock();
          application.navigateToUrl(http.basePath.get() + location.pathname + location.hash + location.search, {
            state: location.state
          });
        } else {
          showSaveTimelineModal();
        }
      }
      if (!getIsTimelineVisible(relativePath) && (changed || timelineStatus === _timeline.TimelineStatus.draft && updated != null)) {
        confirmSaveTimeline();
      } else {
        return;
      }
      return false;
    });
    return () => {
      unblock();
    };
  }, [history, http.basePath, application, overlays, showSaveTimelineModal, getIsTimelineVisible, timelineStatus, updated, changed]);
  (0, _react.useEffect)(() => {
    onAppLeave((actions, nextAppId) => {
      // Confirm when the user has made any changes to a timeline
      if (!(nextAppId !== null && nextAppId !== void 0 ? nextAppId : '').includes(_constants.APP_ID) && (changed || timelineStatus === _timeline.TimelineStatus.draft && updated != null)) {
        return actions.confirm(_translations.UNSAVED_TIMELINE_SAVE_PROMPT, _translations.UNSAVED_TIMELINE_SAVE_PROMPT_TITLE, showSaveTimelineModal);
      } else {
        return actions.default();
      }
    });
    return () => {
      // removing app leave handler for timeline when
      // components containing timeline unmounts
      onAppLeave(actions => actions.default());
    };
  });
};
exports.useTimelineSavePrompt = useTimelineSavePrompt;