"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryTimelineByIdOnUrlChange = exports.getQueryStringKeyValue = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _rison = require("@kbn/rison");
var _store = require("../../../timelines/store");
var _types = require("../../../../common/types");
var _use_selector = require("../use_selector");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _helpers2 = require("../../utils/global_query_string/helpers");
var _use_url_state = require("../use_url_state");
var _use_experimental_features = require("../use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * After the initial load of the security solution, timeline is not updated when the timeline URL search value is changed
 * This is because those state changes happen in place and don't lead to querying data for the new id.
 *
 * But this scenario only happens when there are timelines with conflicted ids. Because it shows a HTML link to the conflicted
 * timeline, which we do not have control of. We already fetch the data on the onClick callback for all other timeline links in the APP.
 * For the conflict scenario, we are actively pulling the id changes that take place for the timeline in the URL and calling the query below
 * to request the new data.
 *
 * *** The conflict scenario can happen when migrating from an older version to 8.0+. Read more: https://github.com/elastic/kibana/issues/100489
 */
const useQueryTimelineByIdOnUrlChange = () => {
  var _flyoutTimeline$saved;
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const flyoutTimeline = (0, _use_selector.useShallowEqualSelector)(state => getTimeline(state, _types.TimelineId.active));
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const oldSearch = (0, _usePrevious.default)(search);
  const timelineIdFromReduxStore = (_flyoutTimeline$saved = flyoutTimeline === null || flyoutTimeline === void 0 ? void 0 : flyoutTimeline.savedObjectId) !== null && _flyoutTimeline$saved !== void 0 ? _flyoutTimeline$saved : '';
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const [previousTimeline, currentTimeline] = (0, _react.useMemo)(() => {
    const oldUrlStateString = getQueryStringKeyValue({
      urlKey: _use_url_state.URL_PARAM_KEY.timeline,
      search: oldSearch !== null && oldSearch !== void 0 ? oldSearch : ''
    });
    const newUrlStateString = getQueryStringKeyValue({
      urlKey: _use_url_state.URL_PARAM_KEY.timeline,
      search
    });
    return oldUrlStateString != null && newUrlStateString != null ? [(0, _rison.safeDecode)(oldUrlStateString), (0, _rison.safeDecode)(newUrlStateString)] : [null, null];
  }, [oldSearch, search]);
  const oldId = previousTimeline === null || previousTimeline === void 0 ? void 0 : previousTimeline.id;
  const {
    id: newId,
    activeTab,
    graphEventId
  } = currentTimeline || {};
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  (0, _react.useEffect)(() => {
    if (newId && newId !== oldId && newId !== timelineIdFromReduxStore) {
      queryTimelineById({
        activeTimelineTab: activeTab !== null && activeTab !== void 0 ? activeTab : _types.TimelineTabs.query,
        duplicate: false,
        graphEventId,
        timelineId: newId,
        openTimeline: true,
        unifiedComponentsInTimelineEnabled
      });
    }
  }, [timelineIdFromReduxStore, oldId, newId, activeTab, graphEventId, queryTimelineById, unifiedComponentsInTimelineEnabled]);
};
exports.useQueryTimelineByIdOnUrlChange = useQueryTimelineByIdOnUrlChange;
const getQueryStringKeyValue = ({
  search,
  urlKey
}) => (0, _helpers2.getParamFromQueryString)((0, _helpers2.getQueryStringFromLocation)(search), urlKey);
exports.getQueryStringKeyValue = getQueryStringKeyValue;