"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitTimelineFromUrlParam = void 0;
var _react = require("react");
var _rison = require("@kbn/rison");
var _types = require("../../../../common/types");
var _global_query_string = require("../../utils/global_query_string");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _use_url_state = require("../use_url_state");
var _use_experimental_features = require("../use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInitTimelineFromUrlParam = () => {
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const isEsqlTabDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('timelineEsqlTabDisabled');
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const onInitialize = (0, _react.useCallback)(initialState => {
    if (initialState != null) {
      queryTimelineById({
        activeTimelineTab: initialState.activeTab === _types.TimelineTabs.esql && isEsqlTabDisabled ? _types.TimelineTabs.query : initialState.activeTab,
        duplicate: false,
        graphEventId: initialState.graphEventId,
        timelineId: initialState.id,
        openTimeline: initialState.isOpen,
        savedSearchId: initialState.savedSearchId,
        unifiedComponentsInTimelineEnabled
      });
    }
  }, [isEsqlTabDisabled, queryTimelineById, unifiedComponentsInTimelineEnabled]);
  (0, _react.useEffect)(() => {
    const listener = () => {
      const timelineState = new URLSearchParams(window.location.search).get(_use_url_state.URL_PARAM_KEY.timeline);
      if (!timelineState) {
        return;
      }
      const parsedState = (0, _rison.safeDecode)(timelineState);
      onInitialize(parsedState);
    };

    // This is needed to initialize the timeline from the URL when the user clicks the back / forward buttons
    window.addEventListener('popstate', listener);
    return () => window.removeEventListener('popstate', listener);
  }, [onInitialize]);
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.timeline, onInitialize);
};
exports.useInitTimelineFromUrlParam = useInitTimelineFromUrlParam;