"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlAvailability = void 0;
var _react = require("react");
var _esqlUtils = require("@kbn/esql-utils");
var _kibana = require("../../lib/kibana");
var _use_experimental_features = require("../use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook combines the checks for esql availability within the security solution
 * If the advanced setting is disabled, ESQL will not be accessible in the UI for any new timeline or new rule creation workflows
 * The feature flags are still available to provide users an escape hatch in case of any esql related performance issues
 */
const useEsqlAvailability = () => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const isEsqlAdvancedSettingEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_esqlUtils.ENABLE_ESQL);
  const isTimelineEsqlFeatureFlagDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('timelineEsqlTabDisabled');
  const isEsqlRuleTypeEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('esqlRulesDisabled') && isEsqlAdvancedSettingEnabled;
  return (0, _react.useMemo)(() => ({
    isEsqlAdvancedSettingEnabled,
    isEsqlRuleTypeEnabled,
    isTimelineEsqlEnabledByFeatureFlag: !isTimelineEsqlFeatureFlagDisabled
  }), [isEsqlAdvancedSettingEnabled, isTimelineEsqlFeatureFlagDisabled, isEsqlRuleTypeEnabled]);
};
exports.useEsqlAvailability = useEsqlAvailability;