"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEql = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _eql = require("../../../../common/search_strategy/eql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEql = async ({
  data,
  dataViewTitle,
  query,
  signal,
  runtimeMappings,
  options
}) => {
  const {
    rawResponse: response
  } = await (0, _rxjs.firstValueFrom)(data.search.search({
    params: {
      index: dataViewTitle,
      body: {
        query,
        runtime_mappings: runtimeMappings,
        size: 0
      },
      timestamp_field: options === null || options === void 0 ? void 0 : options.timestampField,
      tiebreaker_field: (options === null || options === void 0 ? void 0 : options.tiebreakerField) || undefined,
      event_category_field: options === null || options === void 0 ? void 0 : options.eventCategoryField
    },
    options: {
      ignore: [400]
    }
  }, {
    strategy: _common.EQL_SEARCH_STRATEGY,
    abortSignal: signal
  }));
  if ((0, _eql.isValidationErrorResponse)(response)) {
    return {
      valid: false,
      errors: (0, _eql.getValidationErrors)(response)
    };
  } else if ((0, _eql.isErrorResponse)(response)) {
    throw new Error(JSON.stringify(response));
  } else {
    return {
      valid: true,
      errors: []
    };
  }
};
exports.validateEql = validateEql;