"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignalHelpers = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _store = require("../../store");
var _ = require(".");
var _model = require("../../store/sourcerer/model");
var _use_data_view = require("../source/use_data_view");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var _kibana = require("../../lib/kibana");
var _create_sourcerer_data_view = require("./create_sourcerer_data_view");
var _sourcerer = require("../../store/sourcerer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSignalHelpers = () => {
  const {
    indicesExist,
    dataViewId
  } = (0, _.useSourcererDataView)(_model.SourcererScopeName.detections);
  const {
    indexFieldsSearch
  } = (0, _use_data_view.useDataView)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const signalIndexNameSourcerer = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const signalIndexNeedsInit = (0, _react.useMemo)(() => !defaultDataView.title.includes(`${signalIndexNameSourcerer}`), [defaultDataView.title, signalIndexNameSourcerer]);
  const shouldWePollForIndex = (0, _react.useMemo)(() => !indicesExist && !signalIndexNeedsInit, [indicesExist, signalIndexNeedsInit]);
  const pollForSignalIndex = (0, _react.useCallback)(() => {
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      try {
        const sourcererDataView = await (0, _create_sourcerer_data_view.createSourcererDataView)({
          body: {
            patternList: defaultDataView.title.split(',')
          },
          signal: abortCtrl.current.signal,
          dataViewId,
          dataViewService: dataViews
        });
        if (signalIndexNameSourcerer !== null && sourcererDataView !== null && sourcererDataView !== void 0 && sourcererDataView.defaultDataView.patternList.includes(signalIndexNameSourcerer)) {
          // first time signals is defined and validated in the sourcerer
          // redo indexFieldsSearch
          indexFieldsSearch({
            dataViewId: sourcererDataView.defaultDataView.id
          });
          dispatch(_sourcerer.sourcererActions.setSourcererDataViews(sourcererDataView));
        }
      } catch (err) {
        if (err.name === 'AbortError') {
          // the fetch was canceled, we don't need to do anything about it
        } else {
          addError(err, {
            title: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.title', {
              defaultMessage: 'Error updating Security Data View'
            }),
            toastMessage: _i18n.i18n.translate('xpack.securitySolution.sourcerer.error.toastMessage', {
              defaultMessage: 'Refresh the page'
            })
          });
        }
      }
    };
    if (signalIndexNameSourcerer !== null) {
      abortCtrl.current.abort();
      asyncSearch();
    }
  }, [addError, dataViewId, dataViews, defaultDataView.title, dispatch, indexFieldsSearch, signalIndexNameSourcerer]);
  return {
    ...(shouldWePollForIndex ? {
      pollForSignalIndex
    } : {}),
    signalIndexNeedsInit
  };
};
exports.useSignalHelpers = useSignalHelpers;