"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsByIds = void 0;
var _react = require("react");
var _use_query = require("../../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../../detections/containers/detection_engine/alerts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// It prevents recreating the array on every hook call
const ALL_FIELD = ['*'];

/**
 * Fetches the alert documents associated to the ids that are passed.
 * By default it fetches all fields but they can be limited by passing
 * the `fields` parameter.
 */
const useAlertsByIds = ({
  alertIds,
  fields = ALL_FIELD
}) => {
  const [initialQuery] = (0, _react.useState)(() => generateAlertByIdsQuery(alertIds, fields));
  const {
    loading,
    data,
    setQuery
  } = (0, _use_query.useQueryAlerts)({
    query: initialQuery,
    queryName: _constants.ALERTS_QUERY_NAMES.BY_ID
  });
  (0, _react.useEffect)(() => {
    setQuery(generateAlertByIdsQuery(alertIds, fields));
  }, [setQuery, alertIds, fields]);
  const error = !loading && data === undefined;
  return {
    loading,
    error,
    data: data === null || data === void 0 ? void 0 : data.hits.hits
  };
};
exports.useAlertsByIds = useAlertsByIds;
const generateAlertByIdsQuery = (alertIds, fields) => {
  return {
    fields,
    _source: false,
    query: {
      ids: {
        values: alertIds
      }
    }
  };
};