"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withDataView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _data_view_error = require("./data_view_error");
var _use_get_sourcerer_data_view = require("../sourcerer/use_get_sourcerer_data_view");
var _model = require("../../store/sourcerer/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * This HOC makes sure the dataView is populated
 * otherwise it will render the provided/default Error component
 *
 * */
const withDataView = (Component, fallback) => {
  const ComponentWithDataView = props => {
    const dataView = (0, _use_get_sourcerer_data_view.useGetScopedSourcererDataView)({
      sourcererScope: _model.SourcererScopeName.timeline
    });
    if (!dataView) {
      return fallback !== null && fallback !== void 0 ? fallback : /*#__PURE__*/_react.default.createElement(_data_view_error.DataViewErrorComponent, null);
    }
    return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      dataView: dataView
    }));
  };
  return ComponentWithDataView;
};
exports.withDataView = withDataView;