"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSaveToLibrary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _reactDom = require("react-dom");
var _kibana = require("../../lib/kibana");
var _use_redirect_to_dashboard_from_lens = require("./use_redirect_to_dashboard_from_lens");
var _common = require("../../../../common");
var _link_to = require("../link_to");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSaveToLibrary = ({
  attributes
}) => {
  const {
    lens,
    theme,
    i18n
  } = (0, _kibana.useKibana)().services;
  const {
    SaveModalComponent,
    canUseEditor
  } = lens;
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const {
    redirectTo,
    getEditOrCreateDashboardPath
  } = (0, _use_redirect_to_dashboard_from_lens.useRedirectToDashboardFromLens)({
    getSecuritySolutionUrl
  });
  const openSaveVisualizationFlyout = (0, _react.useCallback)(() => {
    const targetDomElement = document.createElement('div');
    const mount = (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(SaveModalComponent, {
      initialInput: attributes,
      onSave: saveProps => {
        (0, _reactDom.unmountComponentAtNode)(targetDomElement);
      },
      onClose: () => {
        (0, _reactDom.unmountComponentAtNode)(targetDomElement);
      },
      originatingApp: _common.APP_UI_ID,
      getOriginatingPath: dashboardId => `${_common.SecurityPageName.dashboards}/${getEditOrCreateDashboardPath(dashboardId)}`,
      redirectTo: redirectTo
    }), {
      theme,
      i18n
    });
    mount(targetDomElement);
  }, [SaveModalComponent, attributes, getEditOrCreateDashboardPath, i18n, redirectTo, theme]);
  const disableVisualizations = (0, _react.useMemo)(() => !canUseEditor() || attributes == null, [attributes, canUseEditor]);
  return {
    openSaveVisualizationFlyout,
    disableVisualizations
  };
};
exports.useSaveToLibrary = useSaveToLibrary;