"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddableInspect = void 0;
var _react = require("react");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEmbeddableInspect = onEmbeddableLoad => {
  const setInspectData = (0, _react.useCallback)((isLoading, adapters) => {
    var _adapters$requests;
    if (!adapters) {
      return;
    }
    const data = (0, _utils.getRequestsAndResponses)(adapters === null || adapters === void 0 ? void 0 : (_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequests());
    onEmbeddableLoad === null || onEmbeddableLoad === void 0 ? void 0 : onEmbeddableLoad({
      requests: data.requests,
      responses: data.responses,
      isLoading
    });
  }, [onEmbeddableLoad]);
  return {
    setInspectData
  };
};
exports.useEmbeddableInspect = useEmbeddableInspect;