"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopN = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _events_by_dataset = require("../../../overview/components/events_by_dataset");
var _signals_by_category = require("../../../overview/components/signals_by_category");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopNContainer = _styledComponents.default.div`
  min-width: 600px;
`;
const CloseButton = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  position: absolute;
  right: 4px;
  top: 4px;
`;
const ViewSelect = (0, _styledComponents.default)(_eui.EuiSuperSelect)`
  width: 170px;
`;
const TopNContent = _styledComponents.default.div`
  margin-top: 4px;
  margin-right: ${({
  theme
}) => theme.eui.euiSizeXS};

  .euiPanel {
    border: none;
  }
`;
const TopNComponent = ({
  combinedQueries,
  defaultView,
  deleteQuery,
  filters,
  field,
  from,
  indexPattern,
  options,
  paddingSize,
  query,
  setAbsoluteRangeDatePickerTarget,
  setQuery,
  scopeId,
  to,
  toggleTopN,
  applyGlobalQueriesAndFilters
}) => {
  const [view, setView] = (0, _react.useState)(defaultView);
  const onViewSelected = (0, _react.useCallback)(value => setView(value), [setView]);
  const sourcererScopeId = (0, _helpers.getSourcererScopeName)({
    scopeId,
    view
  });
  (0, _react.useEffect)(() => {
    setView(defaultView);
  }, [defaultView]);
  const headerChildren = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(ViewSelect, {
    "data-test-subj": "view-select",
    disabled: options.length === 1,
    onChange: onViewSelected,
    options: options,
    valueOfSelected: view
  }), [onViewSelected, options, view]);

  // alert workflow statuses (e.g. open | closed) and other alert-specific
  // filters must be ignored when viewing raw alerts
  const applicableFilters = (0, _react.useMemo)(() => (0, _helpers.removeIgnoredAlertFilters)({
    filters,
    tableId: scopeId,
    view
  }), [filters, scopeId, view]);
  return /*#__PURE__*/_react.default.createElement(TopNContainer, {
    "data-test-subj": "topN-container"
  }, /*#__PURE__*/_react.default.createElement(TopNContent, null, view === 'raw' || view === 'all' ? /*#__PURE__*/_react.default.createElement(_events_by_dataset.EventsByDataset, {
    combinedQueries: combinedQueries,
    deleteQuery: deleteQuery,
    filters: applicableFilters,
    from: from,
    headerChildren: headerChildren,
    indexPattern: indexPattern,
    onlyField: field,
    paddingSize: paddingSize,
    query: query,
    queryType: "topN",
    setQuery: setQuery,
    showSpacer: false,
    toggleTopN: toggleTopN,
    sourcererScopeId: sourcererScopeId,
    to: to,
    hideQueryToggle: true,
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters
  }) : /*#__PURE__*/_react.default.createElement(_signals_by_category.SignalsByCategory, {
    filters: applicableFilters,
    headerChildren: headerChildren,
    onlyField: field,
    paddingSize: paddingSize,
    setAbsoluteRangeDatePickerTarget: setAbsoluteRangeDatePickerTarget,
    hideQueryToggle: true
  })), /*#__PURE__*/_react.default.createElement(CloseButton, {
    "aria-label": i18n.CLOSE,
    "data-test-subj": "close",
    iconType: "cross",
    onClick: toggleTopN
  }));
};
TopNComponent.displayName = 'TopNComponent';
const TopN = exports.TopN = /*#__PURE__*/_react.default.memo(TopNComponent);