"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialState = exports.createAlertTagsReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  selectableAlertTags: [],
  tagsToAdd: new Set(),
  tagsToRemove: new Set()
};
const createAlertTagsReducer = () => (state, action) => {
  switch (action.type) {
    case 'addAlertTag':
      {
        const {
          value
        } = action;
        state.tagsToAdd.add(value);
        state.tagsToRemove.delete(value);
        return state;
      }
    case 'removeAlertTag':
      {
        const {
          value
        } = action;
        state.tagsToRemove.add(value);
        state.tagsToAdd.delete(value);
        return state;
      }
    case 'setSelectableAlertTags':
      {
        const {
          value
        } = action;
        return {
          ...state,
          selectableAlertTags: value
        };
      }
    default:
      return state;
  }
};
exports.createAlertTagsReducer = createAlertTagsReducer;