"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sessionsHeaders = exports.getSessionsDefaultModel = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _default_headers = require("../../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../../timelines/components/timeline/body/constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sessionsHeaders = exports.sessionsHeaders = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.start',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH,
  display: _translations.COLUMN_SESSION_START
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.executable',
  display: _translations.COLUMN_EXECUTABLE
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.user.id',
  display: _translations.COLUMN_ENTRY_USER_ID
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.interactive',
  display: _translations.COLUMN_INTERACTIVE
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'host.hostname',
  display: _translations.COLUMN_HOST_NAME
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'process.entry_leader.entry_meta.type',
  display: _translations.COLUMN_ENTRY_TYPE
}, {
  id: 'process.entry_leader.entry_meta.source.ip',
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  display: _translations.COLUMN_ENTRY_IP
}];
const getSessionsDefaultModel = (columns, defaultColumns) => ({
  ..._securitysolutionDataTable.tableDefaults,
  columns,
  defaultColumns,
  sort: [{
    columnId: 'process.entry_leader.start',
    columnType: 'date',
    sortDirection: 'desc'
  }]
});
exports.getSessionsDefaultModel = getSessionsDefaultModel;