"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Post = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _formatted_date = require("../../formatted_date");
var _helpers = require("../helpers");
var _news_link = require("../news_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewsItemPreviewImage = _styledComponents.default.img`
  height: 56px;
  margin-left: 16px;
  min-width: 56px;
  padding: 4px;
  width: 56px;
`;
const Post = exports.Post = /*#__PURE__*/_react.default.memo(({
  newsItem
}) => {
  const {
    linkUrl,
    title,
    publishOn,
    description,
    imageUrl
  } = newsItem;
  if (!(0, _helpers.showNewsItem)(newsItem)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_news_link.NewsLink, {
    href: linkUrl
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedP1DTDate, {
    value: publishOn
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, imageUrl && /*#__PURE__*/_react.default.createElement(NewsItemPreviewImage, {
    alt: title,
    className: "euiPanel",
    src: imageUrl
  }))));
});
Post.displayName = 'Post';