"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDescriptionList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _score_health = require("./score_health");
var _formatted_date = require("../../formatted_date");
var _create_influencers = require("../influencers/create_influencers");
var i18n = _interopRequireWildcard(require("./translations"));
var _create_explorer_link = require("../links/create_explorer_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LargeScore = (0, _styledComponents.default)(_eui.EuiText)`
  font-size: 45px;
  font-weight: lighter;
`;
LargeScore.displayName = 'LargeScore';
const createDescriptionList = (score, startDate, endDate, interval, narrowDateRange, jobName) => {
  const descriptionList = [{
    title: i18n.MAX_ANOMALY_SCORE,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(LargeScore, null, (0, _score_health.getScoreString)(score.severity)))
  }, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), i18n.ANOMALY_JOB),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, jobName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_create_explorer_link.ExplorerLink, {
      score: score,
      startDate: startDate,
      endDate: endDate,
      linkName: i18n.VIEW_IN_MACHINE_LEARNING
    })))
  }, {
    title: i18n.DETECTED,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(score.time)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "anomaly-description-narrow-range-link",
      onClick: () => {
        narrowDateRange(score, interval);
      },
      target: "_blank"
    }, i18n.NARROW_TO_THIS_DATE_RANGE)))
  }, {
    title: i18n.ANOMALOUS_ENTITY,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, `${score.entityName}: "${score.entityValue}"`))
  }, {
    title: i18n.INFLUENCED_BY,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      responsive: false
    }, (0, _create_influencers.createInfluencers)(score.influencers))
  }];
  return descriptionList;
};
exports.createDescriptionList = createDescriptionList;