"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyScoreComponent = exports.AnomalyScore = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _score = require("./score");
var _create_description_list = require("./create_description_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  vertical-align: text-bottom;
  cursor: pointer;
`;
Icon.displayName = 'Icon';
const AnomalyScoreComponent = ({
  startDate,
  endDate,
  index = 0,
  score,
  interval,
  narrowDateRange,
  jobName
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "anomaly-score"
  }, /*#__PURE__*/_react.default.createElement(_score.Score, {
    index: index,
    score: score
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "anomaly-score-popover",
    id: "anomaly-score-popover",
    isOpen: isOpen,
    onClick: () => setIsOpen(!isOpen),
    closePopover: () => setIsOpen(!isOpen),
    button: /*#__PURE__*/_react.default.createElement(Icon, {
      type: "iInCircle"
    }),
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "anomaly-description-list",
    listItems: (0, _create_description_list.createDescriptionList)(score, startDate, endDate, interval, narrowDateRange, jobName)
  }))));
};
exports.AnomalyScoreComponent = AnomalyScoreComponent;
AnomalyScoreComponent.displayName = 'AnomalyScoreComponent';
const AnomalyScore = exports.AnomalyScore = /*#__PURE__*/_react.default.memo(AnomalyScoreComponent);
AnomalyScore.displayName = 'AnomalyScore';