"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstalledSecurityJobsIds = exports.useInstalledSecurityJobs = exports.useInstalledSecurityJobNameById = void 0;
var _react = require("react");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _is_security_job = require("../../../../../common/machine_learning/is_security_job");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_fetch_jobs_summary_query = require("./use_fetch_jobs_summary_query");
var _use_ml_capabilities = require("./use_ml_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a collection of installed ML jobs (MlSummaryJob) relevant to
 * Security Solution, i.e. all installed jobs in the `security` ML group.
 * Use the corresponding helper functions to filter the job list as
 * necessary (running jobs, etc).
 *
 * NOTE: If you need to include jobs that are not currently installed, try the
 * {@link useSecurityJobs} hook.
 *
 */
const useInstalledSecurityJobs = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const isMlUser = (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities);
  const isLicensed = (0, _has_ml_license.hasMlLicense)(mlCapabilities);
  const {
    isFetching,
    data: jobs = []
  } = (0, _use_fetch_jobs_summary_query.useFetchJobsSummaryQuery)({}, {
    enabled: isMlUser && isLicensed,
    onError: error => {
      addError(error, {
        title: i18n.SIEM_JOB_FETCH_FAILURE
      });
    }
  });
  const securityJobs = jobs.filter(_is_security_job.isSecurityJob);
  return {
    isLicensed,
    isMlUser,
    jobs: securityJobs,
    loading: isFetching
  };
};
exports.useInstalledSecurityJobs = useInstalledSecurityJobs;
const useInstalledSecurityJobsIds = () => {
  const {
    jobs,
    loading
  } = useInstalledSecurityJobs();
  const jobIds = (0, _react.useMemo)(() => jobs.map(job => job.id), [jobs]);
  return {
    jobIds,
    loading
  };
};
exports.useInstalledSecurityJobsIds = useInstalledSecurityJobsIds;
const useInstalledSecurityJobNameById = () => {
  const {
    jobs,
    loading
  } = useInstalledSecurityJobs();
  const jobNameById = (0, _react.useMemo)(() => jobs.reduce((acc, job) => {
    var _job$customSettings;
    acc[job.id] = (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name;
    return acc;
  }, {}), [jobs]);
  return {
    jobNameById,
    loading
  };
};
exports.useInstalledSecurityJobNameById = useInstalledSecurityJobNameById;