"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _editor = require("./editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/no-unused-prop-types */

/* eslint-enable react/no-unused-prop-types */

const BottomContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => `
    padding: ${theme.eui.euiSizeM} 0;
  `}
`;
const MarkdownEditorForm = exports.MarkdownEditorForm = /*#__PURE__*/_react.default.memo( /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  field,
  dataTestSubj,
  idAria,
  bottomRightContent,
  includePlugins
}, ref) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const [isMarkdownInvalid, setIsMarkdownInvalid] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    error: errorMessage,
    fullWidth: true,
    helpText: field.helpText,
    isInvalid: isInvalid || isMarkdownInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, {
    ref: ref,
    ariaLabel: idAria,
    editorId: id,
    onChange: field.setValue,
    value: field.value,
    "data-test-subj": `${dataTestSubj}-markdown-editor`,
    setIsMarkdownInvalid: setIsMarkdownInvalid,
    includePlugins: includePlugins
  }), bottomRightContent && /*#__PURE__*/_react.default.createElement(BottomContentWrapper, {
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, bottomRightContent))));
}));
MarkdownEditorForm.displayName = 'MarkdownEditorForm';