"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentPlanBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _translations = require("./translations");
var _configs = require("../configs");
var _current_plan_badge = require("../styles/current_plan_badge.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRODUCT_TIER_TRANSLATES = {
  [_configs.ProductTier.essentials]: _translations.PRODUCT_TIER_ESSENTIAL,
  [_configs.ProductTier.complete]: _translations.PRODUCT_TIER_COMPLETE
};
const CurrentPlanBadgeComponent = ({
  currentPlan
}) => {
  var _PRODUCT_TIER_TRANSLA;
  const {
    wrapperStyles,
    textStyles
  } = (0, _current_plan_badge.useCurrentPlanBadgeStyles)();
  const wrapperClassNames = (0, _classnames.default)('eui-alignMiddle', wrapperStyles);
  return currentPlan ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    className: wrapperClassNames,
    "data-test-subj": "product-tier-badge"
  }, /*#__PURE__*/_react.default.createElement("strong", {
    className: textStyles
  }, (_PRODUCT_TIER_TRANSLA = PRODUCT_TIER_TRANSLATES[currentPlan]) !== null && _PRODUCT_TIER_TRANSLA !== void 0 ? _PRODUCT_TIER_TRANSLA : currentPlan)) : null;
};
const CurrentPlanBadge = exports.CurrentPlanBadge = /*#__PURE__*/_react.default.memo(CurrentPlanBadgeComponent);